/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.storages.StorageInterface;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class TaskWithAllowWarningTest {
    @Inject
    private StorageInterface storageInterface;
    @Inject
    private FlowInputOutput flowIO;
    @Inject
    private TestRunnerUtils runnerUtils;

    @Test
    @ExecuteFlow(value="flows/valids/task-allow-warning-runnable.yml")
    void runnableTask(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((int)((TaskRun)execution.findTaskRunsByTaskId("fail").getFirst()).getAttempts().size()).isEqualTo(3);
    }

    @Test
    @LoadFlows(value={"flows/valids/task-allow-warning-executable-flow.yml", "flows/valids/for-each-item-subflow-failed.yaml"})
    void executableTask_Flow() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "task-allow-warning-executable-flow");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
    }

    @Test
    @Disabled(value="This test does not test failing in subflow foreach as the subflow is not called, needs to be rework before reactivation")
    @LoadFlows(value={"flows/valids/task-allow-warning-executable-foreachitem.yml"})
    void executableTask_ForEachItem() throws TimeoutException, QueueException, URISyntaxException, IOException {
        URI file = this.storageUpload();
        Map<String, String> inputs = Map.of("file", file.toString());
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "task-allow-warning-executable-foreachitem", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, inputs));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
    }

    @Test
    @ExecuteFlow(value="flows/valids/task-allow-warning-flowable.yml")
    void flowableTask(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
    }

    private URI storageUpload() throws URISyntaxException, IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), this.content(), new OpenOption[0]);
        return this.storageInterface.put("main", null, new URI("/file/storage/file.txt"), (InputStream)new FileInputStream(tempFile));
    }

    private List<String> content() {
        return IntStream.range(0, 10).mapToObj(value -> StringUtils.leftPad((String)("" + value), (int)20)).toList();
    }
}

