/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class TaskWithRunIfTest {
    TaskWithRunIfTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/task-runif.yml")
    void runnableTask(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("executed").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("notexecuted").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)execution.findTaskRunsByTaskId("notexecuted").getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("notexecutedflowable").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)execution.findTaskRunsByTaskId("notexecutedflowable").getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("willfailedtheflow").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/task-runif-workingdirectory.yml")
    void runIfWorkingDirectory(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("log_orders").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("log_test").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)execution.findTaskRunsByTaskId("log_test").getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/task-runif-executionupdating.yml")
    void executionUpdatingTask(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("skipSetVariables").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)execution.findTaskRunsByTaskId("skipSetVariables").getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("skipUnsetVariables").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)execution.findTaskRunsByTaskId("skipUnsetVariables").getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SKIPPED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("unsetVariables").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("setVariables").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Map)execution.getVariables()).containsEntry((Object)"list", List.of(Integer.valueOf(42)));
    }
}

