/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.test.flow.TaskFixture;
import io.kestra.core.utils.IdUtils;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.TemporalOffset;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class TestSuiteTest {
    @Inject
    @Named(value="executionQueue")
    protected QueueInterface<Execution> executionQueue;
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    protected FlowRepositoryInterface flowRepository;
    @Inject
    protected ApplicationContext applicationContext;

    TestSuiteTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/return.yaml"})
    void withoutAnyTaskFixture() throws QueueException, TimeoutException {
        List<TaskFixture> fixtures = List.of();
        Execution executionResult = this.runReturnFlow(fixtures, "main");
        Assertions.assertThat((Comparable)executionResult.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TestSuiteTest.assertOutputForTask(executionResult, "task-id").isEqualTo((Object)"task-id");
        TestSuiteTest.assertOutputForTask(executionResult, "flow-id").isEqualTo((Object)"return");
        TestSuiteTest.assertOutputForTask(executionResult, "date").satisfies(new ThrowingConsumer[]{output -> {
            Assertions.assertThat((Object)output).asString().isNotBlank();
            Assertions.assertThat((ZonedDateTime)ZonedDateTime.parse((String)output)).isCloseTo(ZonedDateTime.now(), (TemporalOffset)Assertions.within((long)300L, (TemporalUnit)ChronoUnit.SECONDS));
        }});
    }

    @Test
    @LoadFlows(value={"flows/valids/return.yaml"}, tenantId="tenant1")
    void taskFixture() throws TimeoutException, QueueException {
        List<TaskFixture> fixtures = List.of(TaskFixture.builder().id("date").build());
        Execution executionResult = this.runReturnFlow(fixtures, "tenant1");
        Assertions.assertThat((Comparable)executionResult.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TestSuiteTest.assertOutputForTask(executionResult, "task-id").isEqualTo((Object)"task-id");
        TestSuiteTest.assertOutputForTask(executionResult, "flow-id").isEqualTo((Object)"return");
        TestSuiteTest.assertOutputForTask(executionResult, "date").isNull();
    }

    @Test
    @LoadFlows(value={"flows/valids/return.yaml"}, tenantId="tenant2")
    void twoTaskFixturesOverridingOutput() throws QueueException, TimeoutException {
        List<TaskFixture> fixtures = List.of(TaskFixture.builder().id("date").outputs(Map.of("value", "my-mocked-output-value")).build(), TaskFixture.builder().id("flow-id").outputs(Map.of("value", "my-mocked-output-flow-id")).build());
        Execution executionResult = this.runReturnFlow(fixtures, "tenant2");
        Assertions.assertThat((Comparable)executionResult.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TestSuiteTest.assertOutputForTask(executionResult, "task-id").isEqualTo((Object)"task-id");
        TestSuiteTest.assertOutputForTask(executionResult, "flow-id").isEqualTo((Object)"my-mocked-output-flow-id");
        TestSuiteTest.assertOutputForTask(executionResult, "date").isEqualTo((Object)"my-mocked-output-value");
    }

    @Test
    @LoadFlows(value={"flows/valids/return.yaml"}, tenantId="tenant3")
    void taskFixturesWithWarningState() throws QueueException, TimeoutException {
        List<TaskFixture> fixtures = List.of(TaskFixture.builder().id("date").state(State.Type.WARNING).build());
        Execution executionResult = this.runReturnFlow(fixtures, "tenant3");
        Assertions.assertThat((Comparable)executionResult.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        TestSuiteTest.assertTask(executionResult, "task-id").extracting(TaskRun::getState).extracting(State::getCurrent).isEqualTo((Object)State.Type.SUCCESS);
        TestSuiteTest.assertTask(executionResult, "flow-id").extracting(TaskRun::getState).extracting(State::getCurrent).isEqualTo((Object)State.Type.SUCCESS);
        TestSuiteTest.assertTask(executionResult, "date").extracting(TaskRun::getState).extracting(State::getCurrent).isEqualTo((Object)State.Type.WARNING);
    }

    private Execution runReturnFlow(List<TaskFixture> fixtures, String tenantId) throws TimeoutException, QueueException {
        Flow flow = (Flow)this.flowRepository.findById(tenantId, "io.kestra.tests", "return", Optional.empty()).orElseThrow();
        Execution execution = Execution.builder().id(IdUtils.create()).tenantId(flow.getTenantId()).namespace(flow.getNamespace()).flowId(flow.getId()).flowRevision(flow.getRevision()).fixtures(fixtures).state(new State()).build();
        return this.runnerUtils.runOne(execution, flow, Duration.ofSeconds(10L));
    }

    private static AbstractObjectAssert<?, Object> assertOutputForTask(Execution executionResult, String taskId) {
        return TestSuiteTest.assertTask(executionResult, taskId).extracting(TaskRun::getOutputs).extracting(x -> x.get((Object)"value"));
    }

    private static ObjectAssert<TaskRun> assertTask(Execution executionResult, String taskId) {
        return (ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)executionResult.getTaskRunList()).filteredOn(x -> taskId.equals(x.getTaskId()))).hasSize(1)).first();
    }
}

