/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.tasks.FileExistComportment;
import io.kestra.core.runners.LocalWorkingDir;
import io.kestra.core.runners.WorkingDir;
import io.kestra.core.utils.IdUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public final class TestWorkingDir
implements WorkingDir {
    private final String id;
    private final WorkingDir delegate;
    private final List<Path> allCreatedTempFiles = new ArrayList<Path>();
    private final List<Path> allCreatedFiles = new ArrayList<Path>();
    private boolean isCleaned = false;

    public static TestWorkingDir create() {
        String id = IdUtils.create();
        return new TestWorkingDir(id, (WorkingDir)new LocalWorkingDir(Path.of("/tmp", new String[0]), id));
    }

    public static TestWorkingDir create(String tmpdirBasePath) {
        String id = IdUtils.create();
        return new TestWorkingDir(id, (WorkingDir)new LocalWorkingDir(Path.of(tmpdirBasePath, new String[0]), id));
    }

    public TestWorkingDir(String id, WorkingDir delegate) {
        this.id = id;
        this.delegate = delegate;
    }

    public String id() {
        return this.id;
    }

    public Path path() {
        return this.delegate.path();
    }

    public Path path(boolean create) {
        return this.delegate.path(create);
    }

    public Path resolve(Path path) {
        return this.delegate.resolve(path);
    }

    public Path createTempFile() throws IOException {
        return this.captureCreateTempFileAndGet(this.delegate.createTempFile());
    }

    public Path createTempFile(String extension) throws IOException {
        return this.captureCreateTempFileAndGet(this.delegate.createTempFile(extension));
    }

    public Path createTempFile(byte[] content) throws IOException {
        return this.captureCreateTempFileAndGet(this.delegate.createTempFile(content));
    }

    public Path createTempFile(byte[] content, String extension) throws IOException {
        return this.captureCreateFileAndGet(this.delegate.createTempFile(content, extension));
    }

    public Path createFile(String filename) throws IOException {
        return this.captureCreateFileAndGet(this.delegate.createFile(filename));
    }

    public Path createFile(String filename, byte[] content) throws IOException {
        return this.captureCreateFileAndGet(this.delegate.createFile(filename, content));
    }

    public Path createFile(String filename, InputStream content) throws IOException {
        return this.captureCreateFileAndGet(this.delegate.createFile(filename, content));
    }

    public Path putFile(Path path, InputStream content) throws IOException {
        return this.putFile(path, content, FileExistComportment.OVERWRITE);
    }

    public Path putFile(Path path, InputStream content, FileExistComportment comportment) throws IOException {
        return this.captureCreateFileAndGet(this.delegate.putFile(path, content, comportment));
    }

    public List<Path> findAllFilesMatching(List<String> patterns) throws IOException {
        return this.delegate.findAllFilesMatching(patterns);
    }

    public void cleanup() throws IOException {
        this.delegate.cleanup();
        this.isCleaned = true;
    }

    public boolean isCleaned() {
        return this.isCleaned;
    }

    public List<Path> getAllCreatedFilesAndTempFiles() {
        return Stream.concat(this.allCreatedTempFiles.stream(), this.allCreatedFiles.stream()).toList();
    }

    public List<Path> getAllCreatedFiles() {
        return Collections.unmodifiableList(this.allCreatedFiles);
    }

    public List<Path> getAllCreatedTempFiles() {
        return Collections.unmodifiableList(this.allCreatedTempFiles);
    }

    private Path captureCreateTempFileAndGet(Path path) {
        this.allCreatedTempFiles.add(path);
        return path;
    }

    private Path captureCreateFileAndGet(Path path) {
        this.allCreatedFiles.add(path);
        return path;
    }
}

