/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class VariableRendererTest {
    @Inject
    ApplicationContext applicationContext;
    @Inject
    VariableRenderer.VariableConfiguration variableConfiguration;
    @Inject
    VariableRenderer variableRenderer;

    VariableRendererTest() {
    }

    @Test
    void shouldRenderUsingAlternativeRendering() throws IllegalVariableEvaluationException {
        TestVariableRenderer renderer = new TestVariableRenderer(this.applicationContext, this.variableConfiguration);
        String render = renderer.render("{{ dummy }}", Map.of());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"result", (Object)render);
    }

    @Test
    void shouldRenderContactUntypedStringExpression() throws IllegalVariableEvaluationException {
        TestVariableRenderer renderer = new TestVariableRenderer(this.applicationContext, this.variableConfiguration);
        String render = renderer.render("{{ prefix }}.kestra.{{ suffix }}", Map.of("prefix", "io", "suffix", "unittest"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"io.kestra.unittest", (Object)render);
    }

    @Test
    void shouldRenderContactTypedStringExpression() throws IllegalVariableEvaluationException {
        TestVariableRenderer renderer = new TestVariableRenderer(this.applicationContext, this.variableConfiguration);
        Object render = renderer.renderTyped("{{ prefix }}.kestra.{{ suffix }}", Map.of("prefix", "io", "suffix", "unittest"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"io.kestra.unittest", (Object)render);
    }

    @Test
    void shouldRenderContactTypedNumberExpression() throws IllegalVariableEvaluationException {
        TestVariableRenderer renderer = new TestVariableRenderer(this.applicationContext, this.variableConfiguration);
        Object render = renderer.renderTyped("{{ prefix }}{{ suffix }}", Map.of("prefix", 10, "suffix", 42L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1042", (Object)render);
    }

    @Test
    void shouldRenderTypedValueExpression() throws IllegalVariableEvaluationException {
        TestVariableRenderer renderer = new TestVariableRenderer(this.applicationContext, this.variableConfiguration);
        for (BigDecimal o : List.of(Integer.valueOf(42), Double.valueOf(3.14), Boolean.valueOf(true), Character.valueOf('x'), "hello", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Map.of("a", 1), new Object(), new BigDecimal("123.45"))) {
            Object render = renderer.renderTyped("{{ input }}", Map.of("input", o));
            org.junit.jupiter.api.Assertions.assertEquals((Object)o, (Object)render);
        }
    }

    @Test
    void shouldKeepKeyOrderWhenRenderingMap() throws IllegalVariableEvaluationException {
        LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
        input.put("foo-1", "A");
        input.put("foo-2", "B");
        LinkedHashMap<String, String> input_value3 = new LinkedHashMap<String, String>();
        input_value3.put("bar-1", "C");
        input_value3.put("bar-2", "D");
        input_value3.put("bar-3", "E");
        input.put("foo-3", input_value3);
        Map result = this.variableRenderer.render(input, Map.of());
        Assertions.assertThat(result.keySet()).containsExactly((Object[])new String[]{"foo-1", "foo-2", "foo-3"});
        Map result_value3 = (Map)result.get("foo-3");
        Assertions.assertThat(result_value3.keySet()).containsExactly((Object[])new String[]{"bar-1", "bar-2", "bar-3"});
    }

    public static class TestVariableRenderer
    extends VariableRenderer {
        public TestVariableRenderer(ApplicationContext applicationContext, VariableRenderer.VariableConfiguration variableConfiguration) {
            super(applicationContext, variableConfiguration);
        }

        protected String alternativeRender(Exception e, String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
            return "result";
        }
    }
}

