/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.utils.Rethrow;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class PebbleVariableRendererTest {
    @Inject
    VariableRenderer variableRenderer;

    PebbleVariableRendererTest() {
    }

    @Test
    void out() throws IllegalVariableEvaluationException {
        Map<String, String> in = Map.of("string", "{{ string }}", "int", "{{ int }}", "float", "{{ float }}", "list", "{{ list }}", "bool", "{{ bool }}", "date", "{{ date }}", "map", "{{ map }}", "escape", "{{ list }} // {{ map }}", "empty", "{{ list[3] is defined ? bla : null }}", "concat", "{{ \"apple\" ~ \"pear\" ~ \"banana\" }}");
        Map<String, Map<String, Float>> vars = Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("string", 1, Float.valueOf(1.123f)), "bool", true, "date", ZonedDateTime.parse("2013-09-08T16:19:00+02"), "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)));
        Map render = this.variableRenderer.render(in, vars);
        Assertions.assertThat(render.get("string")).isEqualTo((Object)"string");
        Assertions.assertThat(render.get("int")).isEqualTo((Object)"1");
        Assertions.assertThat(render.get("float")).isEqualTo((Object)"1.123");
        Assertions.assertThat(render.get("list")).isEqualTo((Object)"[\"string\",1,1.123]");
        Assertions.assertThat(render.get("bool")).isEqualTo((Object)"true");
        Assertions.assertThat(render.get("date")).isEqualTo((Object)"2013-09-08T16:19+02:00");
        Assertions.assertThat((String)((String)render.get("map"))).contains(new CharSequence[]{"\"int\":1"});
        Assertions.assertThat((String)((String)render.get("map"))).contains(new CharSequence[]{"\"int\":1"});
        Assertions.assertThat((String)((String)render.get("map"))).contains(new CharSequence[]{"\"float\":1.123"});
        Assertions.assertThat((String)((String)render.get("map"))).contains(new CharSequence[]{"\"string\":\"string\""});
        Assertions.assertThat((String)((String)render.get("map"))).startsWith((CharSequence)"{");
        Assertions.assertThat((String)((String)render.get("map"))).endsWith((CharSequence)"}");
        Assertions.assertThat((String)((String)render.get("escape"))).contains(new CharSequence[]{"[\"string\",1,1.123] // {"});
        Assertions.assertThat((String)((String)render.get("empty"))).isEqualTo("");
        Assertions.assertThat((String)((String)render.get("concat"))).isEqualTo("applepearbanana");
    }

    @Test
    void autoJson() throws IllegalVariableEvaluationException {
        Map<String, Integer[]> vars = Map.of("map", Map.of("a", "1", "b", "2"), "collection", List.of("1", "2", "3"), "array", new String[]{"1", "2", "3"}, "inta", new Integer[]{1, 2, 3});
        Map<String, String> in = Map.of("map", "{{ map }}", "collection", "{{ collection }}", "array", "{{ array }}", "inta", "{{ inta }}");
        Map render = this.variableRenderer.render(in, vars);
        Assertions.assertThat((String)((String)render.get("map"))).contains(new CharSequence[]{"\"a\":\"1\""});
        Assertions.assertThat((String)((String)render.get("map"))).contains(new CharSequence[]{"\"b\":\"2\""});
        Assertions.assertThat(render.get("collection")).isEqualTo((Object)"[\"1\",\"2\",\"3\"]");
        Assertions.assertThat(render.get("array")).isEqualTo((Object)"[\"1\",\"2\",\"3\"]");
        Assertions.assertThat(render.get("inta")).isEqualTo((Object)"[1,2,3]");
    }

    @Test
    void exception() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> Rethrow.throwSupplier(() -> {
            this.variableRenderer.render("{{ missing is defined ? missing : missing2 }}", Map.of());
            return null;
        }).get());
    }

    @Test
    void macro() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{% block \"post\" %} content {% endblock %}{{ block(\"post\") }}", Map.of());
        Assertions.assertThat((String)render).contains(new CharSequence[]{"content"});
    }

    @Test
    void numberFormat() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ var | numberFormat(\"#.##\") }}", Map.of("var", Float.valueOf(1.232654f)));
        Assertions.assertThat((String)render).contains(new CharSequence[]{"1.23"});
    }

    @Test
    void map() throws IllegalVariableEvaluationException {
        ImmutableMap in = ImmutableMap.of((Object)"string", (Object)"{{test}}", (Object)"list", Arrays.asList("{{test}}", "{{test2}}"), (Object)"int", (Object)1);
        ImmutableMap vars = ImmutableMap.of((Object)"test", (Object)"top", (Object)"test2", (Object)"awesome");
        Map render = this.variableRenderer.render((Map)in, (Map)vars);
        Assertions.assertThat(render.get("string")).isEqualTo((Object)"top");
        Assertions.assertThat((List)((List)render.get("list"))).containsExactlyInAnyOrder((Object[])new String[]{"top", "awesome"});
        Assertions.assertThat(render.get("int")).isEqualTo((Object)1);
    }

    @Test
    void recursive() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"first", (Object)"1", (Object)"second", (Object)"{{first}}", (Object)"third", (Object)"{{second}}", (Object)"fourth", (Object)"{{render(third, recursive=false)}}", (Object)"map", (Object)ImmutableMap.of((Object)"third", (Object)"{{third}}"), (Object)"list", (Object)ImmutableList.of((Object)"{{third}}"), (Object)"set", (Object)ImmutableSet.of((Object)"{{third}}"));
        String render = this.variableRenderer.render("{{ third }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{{second}}");
        render = this.variableRenderer.render("{{ render(third, recursive=false) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{{first}}");
        render = this.variableRenderer.render("{{ render(third) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ render(fourth) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ map }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{\"third\":\"{{third}}\"}");
        render = this.variableRenderer.render("{{ render(map, recursive=false) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{\"third\":\"{{second}}\"}");
        render = this.variableRenderer.render("{{ render(map) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{\"third\":\"1\"}");
        render = this.variableRenderer.render("{{ list }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"{{third}}\"]");
        render = this.variableRenderer.render("{{ render(list, recursive=false) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"{{second}}\"]");
        render = this.variableRenderer.render("{{ render(list) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"1\"]");
        render = this.variableRenderer.render("{{ set }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"{{third}}\"]");
        render = this.variableRenderer.render("{{ render(set, recursive=false) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"{{second}}\"]");
        render = this.variableRenderer.render("{{ render(set) }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"1\"]");
    }

    @Test
    void recursiveRenderingAmountLimit() {
        ImmutableMap vars = ImmutableMap.of((Object)"first", (Object)"{{second}}", (Object)"second", (Object)"{{first}}");
        IllegalVariableEvaluationException illegalVariableEvaluationException = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ render(first) }}", (Map)vars));
        Assertions.assertThat((String)illegalVariableEvaluationException.getMessage()).contains(new CharSequence[]{"Too many rendering attempts"});
    }

    @Test
    void raw() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"var", (Object)"1");
        String render = this.variableRenderer.render("See some code {% raw %}{{ var }}{% endraw %}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("See some code {{ var }}");
        render = this.variableRenderer.render("See some code {%raw%}{{ var }}{%endraw%}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("See some code {{ var }}");
        render = this.variableRenderer.render("See some code {%-  raw%}{{ var }}{%endraw -%}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("See some code {{ var }}");
        render = this.variableRenderer.render("See some code {% raw %}{{ var }}{% endraw %} and some other code {% raw %}{{ var2 }}{% endraw %}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("See some code {{ var }} and some other code {{ var2 }}");
    }

    @Test
    void eval() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", (Object)ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)"child", (Object)"awesome")), (Object)"inner", (Object)"test");
        String render = this.variableRenderer.render("{{ block[inner].child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
    }

    @Test
    void firstDefined() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", (Object)ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)"child", (Object)"awesome")), (Object)"inner", (Object)"test");
        String render = this.variableRenderer.render("{{ inner.bla is not defined ? block.test.child : null }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block.test.child is defined ? block.test.child : inner.bla }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ missing is defined ? missing : missing2 }}", (Map)vars));
    }

    @Test
    void firstDefinedEval() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", (Object)ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)"child", (Object)"awesome")), (Object)"inner", (Object)"test");
        String render = this.variableRenderer.render("{{ block.test.child is defined ? block.test.child : null }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[inner].child is defined ? block[inner].child : null }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[missing].child is defined ? null : block[inner].child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[missing].child is not defined ? (block[missing2].child is not defined ? block[inner].child : null) : null }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ missing is defined ? null : block.test.child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ missing is defined ? missing : missing2 }}", (Map)vars));
    }

    @Test
    void get() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", (Object)ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)"child", (Object)"awesome")), (Object)"inner", (Object)"test");
        String render = this.variableRenderer.render("{{ block['test'] }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{\"child\":\"awesome\"}");
        render = this.variableRenderer.render("{{ block['test']['child'] }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[inner]['child'] }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ get missing }}", (Map)vars));
    }

    @Test
    void mapWithNestedNumberList() throws IllegalVariableEvaluationException {
        Map<String, List<Integer>> map = Map.of("numbers", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Assertions.assertThat((Map)this.variableRenderer.render(map, Map.of())).isEqualTo(map);
    }
}

