/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.micronaut.context.annotation.Property;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
@Property(name="kestra.variables.recursive-rendering", value="true")
class RecursivePebbleVariableRendererTest {
    @Inject
    VariableRenderer variableRenderer;

    RecursivePebbleVariableRendererTest() {
    }

    @Test
    void recursive() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"first", (Object)"1", (Object)"second", (Object)"{{first}}", (Object)"third", (Object)"{{second}}", (Object)"map", (Object)ImmutableMap.of((Object)"third", (Object)"{{third}}"), (Object)"list", (Object)ImmutableList.of((Object)"{{third}}"), (Object)"set", (Object)ImmutableSet.of((Object)"{{third}}"));
        String render = this.variableRenderer.render("{{ third }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ map }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{\"third\":\"1\"}");
        render = this.variableRenderer.render("{{ list }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"1\"]");
        render = this.variableRenderer.render("{{ set }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"1\"]");
    }

    @Test
    void renderFunctionNotInjectedIfRecursiveSettingsTrue() {
        ImmutableMap vars = ImmutableMap.of((Object)"first", (Object)"1");
        IllegalVariableEvaluationException illegalVariableEvaluationException = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ render(first) }}", (Map)vars));
        Assertions.assertThat((String)illegalVariableEvaluationException.getMessage()).contains(new CharSequence[]{"Function or Macro [render] does not exist"});
    }

    @Test
    void renderFunctionKeepRaw() throws IllegalVariableEvaluationException {
        Assertions.assertThat((String)this.variableRenderer.render("{% raw %}{{first}}{% endraw %}", Collections.emptyMap())).isEqualTo("{{first}}");
    }
}

