/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.expression;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.State;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class InExpressionTest {
    @Inject
    VariableRenderer variableRenderer;

    @Test
    void inList() throws IllegalVariableEvaluationException {
        HashMap<String, State.Type> vars = new HashMap<String, State.Type>();
        vars.put("state", State.Type.SUCCESS);
        String render = this.variableRenderer.render("{{ state isIn ['SUCCESS', 'WARNING'] }}", vars);
        Assertions.assertThat((String)render).isEqualTo("true");
        render = this.variableRenderer.render("{{ state isIn ['FAILED', 'KILLED'] }}", vars);
        Assertions.assertThat((String)render).isEqualTo("false");
    }

    @Test
    void inMap() throws IllegalVariableEvaluationException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("map", Map.of("key", "value"));
        vars.put("key", "key");
        vars.put("value", "value");
        String render = this.variableRenderer.render("{{ key isIn map }}", vars);
        Assertions.assertThat((String)render).isEqualTo("true");
        render = this.variableRenderer.render("{{ value isIn map }}", vars);
        Assertions.assertThat((String)render).isEqualTo("true");
    }
}

