/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.expression;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class NullCoalescingExpressionTest {
    @Inject
    VariableRenderer variableRenderer;

    NullCoalescingExpressionTest() {
    }

    @Test
    void firstDefined() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", (Object)ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)"child", (Object)"awesome")), (Object)"inner", (Object)"test");
        String render = this.variableRenderer.render("{{ inner.bla ?? block.test.child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block.test.child ?? inner.bla }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ missing ?? missing2 }}", (Map)vars));
    }

    @Test
    void firstDefinedEval() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", (Object)ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)"child", (Object)"awesome")), (Object)"inner", (Object)"test");
        String render = this.variableRenderer.render("{{ block.test.child ?? null }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[inner].child ?? null }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[missing].child ?? block[inner].child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ block[missing].child ?? block[missing2].child ?? block[inner].child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        render = this.variableRenderer.render("{{ missing ?? block.test.child }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("awesome");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ missing ?? missing2 }}", (Map)vars));
    }

    @Test
    void emptyObject() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"block", Map.of());
        String render = this.variableRenderer.render("{{ block ?? 'UNDEFINED' }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("{}");
    }

    @Test
    void nullOrUndefined() throws IllegalVariableEvaluationException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("null", null);
        String render = this.variableRenderer.render("{{ null ?? 'IS NULL' }}", vars);
        Assertions.assertThat((String)render).isEqualTo("IS NULL");
        render = this.variableRenderer.render("{{ undefined ?? 'IS UNDEFINED' }}", vars);
        Assertions.assertThat((String)render).isEqualTo("IS UNDEFINED");
    }
}

