/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.utils.Rethrow;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ChunkFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    ChunkFilterTest() {
    }

    @Test
    void out() throws IllegalVariableEvaluationException {
        Map<String, List<Integer>> vars = Map.of("list", Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9));
        String render = this.variableRenderer.render("{{ list | chunk(2) }}", vars);
        Assertions.assertThat((String)render).isEqualTo("[[1,2],[3,4],[5,6],[7,8],[9]]");
    }

    @Test
    void exception() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> Rethrow.throwSupplier(() -> {
            this.variableRenderer.render("{{ test | chunk(2) }}", Map.of("test", 1));
            return null;
        }).get());
    }

    @Test
    void chunkWithIntegerVariable() throws IllegalVariableEvaluationException {
        Map<String, List<Integer>> vars = Map.of("max_items", 2, "list", Arrays.asList(1, 2, 3, 4, 5));
        String render = this.variableRenderer.render("{{ list | chunk(max_items) }}", vars);
        Assertions.assertThat((String)render).isEqualTo("[[1,2],[3,4],[5]]");
    }
}

