/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.pebble.filters.DateAddFilter;
import io.pebbletemplates.pebble.error.PebbleException;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
public class DateAddFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    @Test
    void toDateAdd() throws IllegalVariableEvaluationException {
        Map<String, String> vars = Map.of("day", 1, "timezone", "Australia/Perth");
        String render = this.variableRenderer.render("{{ \"2013-09-08T16:19:00+02\" | dateAdd(day, \"DAYS\") | date(\"yyyy-MM-dd HH:mm:ss z\", timeZone=render(timezone)) }}", vars);
        Assertions.assertThat((String)render).isEqualTo("2013-09-09 22:19:00 AWST");
    }

    @Test
    void should_fail_with_invalid_day() {
        Map<String, String> vars = Map.of("day", "invalid", "timezone", "Australia/Perth");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ \"2013-09-08T16:19:00+02\" | dateAdd(day, \"DAYS\") | date(\"yyyy-MM-dd HH:mm:ss z\", timeZone=render(timezone)) }}", vars));
    }

    @Test
    void should_return_null_for_null_input() throws IllegalVariableEvaluationException {
        Map<String, String> vars = Map.of("day", 1, "timezone", "Australia/Perth");
        String render = this.variableRenderer.render("{{ null | dateAdd(day, \"DAYS\") | date(\"yyyy-MM-dd HH:mm:ss z\", timeZone=render(timezone)) }}", vars);
        Assertions.assertThat((String)render).isEmpty();
    }

    @MethodSource(value={"longInput"})
    @ParameterizedTest
    void should_get_as_long(InputWrapper wrapper) {
        Assertions.assertThat((Long)DateAddFilter.getAsLong((Object)wrapper.value, (int)0, null)).isEqualTo(1L);
    }

    static Stream<InputWrapper> longInput() {
        return Stream.of(new InputWrapper(1L), new InputWrapper(1), new InputWrapper(new AtomicInteger(1)), new InputWrapper("1"));
    }

    @MethodSource(value={"invalidInput"})
    @ParameterizedTest
    void should_get_not_get_as_long(InputWrapper wrapper) {
        org.junit.jupiter.api.Assertions.assertThrows(PebbleException.class, () -> DateAddFilter.getAsLong((Object)wrapper.value, (int)0, null));
    }

    static Stream<InputWrapper> invalidInput() {
        return Stream.of(new InputWrapper(null), new InputWrapper("invalidString"));
    }

    record InputWrapper(Object value) {
    }
}

