/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@KestraTest
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class DateFilterTest {
    public static final ZonedDateTime NOW = ZonedDateTime.parse("2013-09-08T16:19:12.123456+01");
    @Inject
    private VariableRenderer variableRenderer;

    DateFilterTest() {
    }

    @Test
    void dateFormat() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"date", (Object)new Date(NOW.toEpochSecond() * 1000L), (Object)"instant", (Object)NOW.toInstant(), (Object)"zoned", (Object)NOW, (Object)"local", (Object)NOW.toLocalDateTime());
        String render = this.variableRenderer.render("{{ date | date(format='iso', timeZone='Europe/Paris') }}\n{{ instant | date(format=\"iso_sec\", timeZone=\"Europe/Paris\") }}\n{{ instant | date(format=\"iso_milli\", timeZone=\"Europe/Paris\") }}\n{{ zoned | date(format=\"iso\", timeZone=\"Europe/Paris\") }}\n{{ zoned | date(format=\"iso_milli\", timeZone=\"Europe/Paris\") }}\n{{ local | date(format=\"yyyy-MM-dd HH:mm:ss.SSSSSSXXX\", timeZone=\"Europe/Paris\") }}\n{{ local | date(format=\"yyyy-MM-dd HH:mm:ss.SSS\", timeZone=\"UTC\") }}\n{{ local | date(format=\"sql\", timeZone=\"UTC\") }}\n{{ local | date(format=\"sql_sec\", timeZone=\"UTC\") }}\n{{ local | date(format=\"sql_milli\", timeZone=\"UTC\") }}\n{{ local | date(format=\"yyyy-MM-dd HH:mm:ss.SSSSSSXXX\", timeZone=\"UTC\") }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("2013-09-08T17:19:12.000000+02:00\n2013-09-08T17:19:12+02:00\n2013-09-08T17:19:12.123+02:00\n2013-09-08T17:19:12.123456+02:00\n2013-09-08T17:19:12.123+02:00\n2013-09-08 16:19:12.123456+02:00\n2013-09-08 16:19:12.123\n2013-09-08 16:19:12.123456\n2013-09-08 16:19:12\n2013-09-08 16:19:12.123\n2013-09-08 16:19:12.123456Z");
    }

    @Test
    void dateStringFormat() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ \"July 24, 2001\" | date(\"yyyy-MM-dd\", existingFormat=\"MMMM dd, yyyy\") }}\n{{ \"2013-09-08T17:19:12+02:00\" | date(timeZone=\"Europe/Paris\") }}\n{{ \"2013-09-08T17:19:12\" | date(timeZone=\"Europe/Paris\") }}\n{{ \"2013-09-08\" | date(timeZone=\"Europe/Paris\") }}\n{{ \"08.09.2023\" | date(\"yyyy-MM-dd\", existingFormat=\"dd.MM.yyyy\") }}\n{{ \"08092023\" | date(\"yyyy-MM-dd\", existingFormat=\"ddMMyyyy\") }}\n", Map.of());
        Assertions.assertThat((String)render).isEqualTo("2001-07-24\n2013-09-08T17:19:12.000000+02:00\n2013-09-08T17:19:12.000000+02:00\n2013-09-08T00:00:00.000000+02:00\n2023-09-08\n2023-09-08\n");
    }

    @Test
    void timestamp() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ zoned | timestamp(timeZone=\"Europe/Paris\") }}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("1378653552");
    }

    @Test
    void timestampCompare() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ (zoned | timestamp) > (zoned | dateAdd(-1, 'DAYS') | timestamp) }}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("true");
    }

    @Test
    void dateRfc() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ 'Tue, 08 Feb 2022 19:38:26 GMT' | date(existingFormat='rfc_1123_date_time', timeZone=\"Europe/Paris\") }}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("2022-02-08T20:38:26.000000+01:00");
    }

    @Test
    void instantNano() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ zoned | timestampNano(timeZone=\"Europe/Paris\") }}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("1378653552123456000");
    }

    @Test
    void instantMicro() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ zoned | timestampMicro(timeZone=\"Europe/Paris\") }}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("1378653552123456");
    }

    @Test
    void instantMilli() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ zoned | timestampMilli(timeZone=\"Europe/Paris\") }}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("1378653552123");
    }

    @Test
    void now() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ now() }}", (Map)ImmutableMap.of());
        Assertions.assertThat((String)render).contains(new CharSequence[]{ZonedDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE)});
        render = this.variableRenderer.render("{{ now(timeZone=\"Europe/Lisbon\") }}", (Map)ImmutableMap.of());
        Assertions.assertThat((String)render).contains(new CharSequence[]{ZonedDateTime.now(ZoneId.of("Europe/Lisbon")).format(DateTimeFormatter.ISO_LOCAL_DATE)});
        Assertions.assertThat((String)render).contains(new CharSequence[]{ZonedDateTime.now(ZoneId.of("Europe/Lisbon")).format(DateTimeFormatter.ofPattern("HH:mm"))});
        render = this.variableRenderer.render("{{ now(format=\"iso_local_date\") }}", (Map)ImmutableMap.of());
        Assertions.assertThat((String)render).isEqualTo(ZonedDateTime.now(ZoneId.of("Europe/Lisbon")).format(DateTimeFormatter.ISO_LOCAL_DATE));
        render = this.variableRenderer.render("{{ now(format=\"sql_milli\") }}", (Map)ImmutableMap.of());
        Assertions.assertThat((String)render).startsWith((CharSequence)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        Assertions.assertThat((String)render).hasSize(23);
    }

    @Test
    void add() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ zoned | dateAdd(-1,\"DAYS\",timeZone=\"Europe/Paris\")}}", (Map)ImmutableMap.of((Object)"zoned", (Object)NOW));
        Assertions.assertThat((String)render).isEqualTo("2013-09-07T17:19:12.123456+02:00");
    }

    @Test
    void timestampDateFormat() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ 1378653552 | date(format=\"iso_sec\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552123 | date(format=\"iso_milli\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552123 | date(timeZone=\"Europe/Paris\") }}\n{{ 1378653552123 | date(format=\"iso_zoned_date_time\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552123456000 | date(format=\"iso\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552000123456 | date(format=\"iso\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552 | date(format=\"sql_sec\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552123 | date(format=\"sql_milli\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552123456000 | date(format=\"sql\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552000123456 | date(format=\"sql\", timeZone=\"Europe/Paris\") }}\n{{ 1378653552123 | date(format=\"sql_milli\", timeZone=\"UTC\") }}\n{{ \"1378653552123\" | number | date(format=\"sql_milli\", timeZone=\"UTC\") }}\n", Map.of());
        Assertions.assertThat((String)render).isEqualTo("2013-09-08T17:19:12+02:00\n2013-09-08T17:19:12.123+02:00\n2013-09-08T17:19:12.123000+02:00\n2013-09-08T17:19:12.123+02:00[Europe/Paris]\n2013-09-08T17:19:12.123456+02:00\n2013-09-08T17:19:12.123456+02:00\n2013-09-08 17:19:12\n2013-09-08 17:19:12.123\n2013-09-08 17:19:12.123456\n2013-09-08 17:19:12.123456\n2013-09-08 15:19:12.123\n2013-09-08 15:19:12.123\n");
    }
}

