/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class DistinctFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    DistinctFilterTest() {
    }

    @Test
    void toDistinctFilter() throws IllegalVariableEvaluationException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("one", "two", "one", "three", "four", "five", "three", 1, 2, 3, 1, 2, 2, Float.valueOf(1.123f), Float.valueOf(2.123f), Float.valueOf(1.123f), Float.valueOf(10.0f), Float.valueOf(10.0f)), "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars.second.list }}", (Map)vars);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"one"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"two"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"three"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"1"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"1.123"});
        String distinctRender = this.variableRenderer.render("{{ vars.second.list | distinct }}", (Map)vars);
        Assertions.assertThat((String)distinctRender).isEqualTo("[\"one\",\"two\",\"three\",\"four\",\"five\",1,2,3,1.123,2.123,10.0]");
        Assertions.assertThat((String)distinctRender).doesNotContain(new CharSequence[]{"one,one"});
        Assertions.assertThat((String)distinctRender).startsWith((CharSequence)"[");
        Assertions.assertThat((String)distinctRender).endsWith((CharSequence)"]");
        render = this.variableRenderer.render("{{ [] | distinct }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("[]");
        render = this.variableRenderer.render("{{ null | distinct }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("null");
    }

    @Test
    void distinctFilterWithInvalidInput() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ \"string\" | distinct }}", Map.of()));
    }

    @Test
    void distinctFilterWithNonListObject() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ {key : \"value\"} | distinct }}", Map.of()));
    }
}

