/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@KestraTest
class EscapeCharFilterTest {
    @Inject
    private VariableRenderer variableRenderer;

    EscapeCharFilterTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideValidTypes"})
    void validTypes(String type, String input, String expected) throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ " + input + " | escapeChar('" + type + "') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo(expected);
    }

    @ParameterizedTest
    @ValueSource(strings={"foo", ""})
    void invalidTypes(String type) {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ 'Hello' | escapeChar('" + type + "') }}", Map.of()));
    }

    private static Stream<Arguments> provideValidTypes() {
        return Stream.of(Arguments.of((Object[])new Object[]{"single", "\"L'eau c'est la vie\"", "L\\'eau c\\'est la vie"}), Arguments.of((Object[])new Object[]{"double", "'\"Hello\"'", "\\\"Hello\\\""}), Arguments.of((Object[])new Object[]{"shell", "\"L'eau c'est la vie\"", "L'\\''eau c'\\''est la vie"}), Arguments.of((Object[])new Object[]{"single", "''", ""}), Arguments.of((Object[])new Object[]{"double", "''", ""}), Arguments.of((Object[])new Object[]{"shell", "''", ""}));
    }
}

