/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class JqFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    JqFilterTest() {
    }

    @Test
    void fromString() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ [1, 2, 3] | jq(\".[0]\") | first }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ my_vars | jq(\".test[0]\") }}", Map.of("my_vars", Map.of("test", Arrays.asList(1, 2, 3))));
        Assertions.assertThat((String)render).isEqualTo("[1]");
    }

    @Test
    void simple() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"first", (Object)ImmutableMap.of((Object)"second", (Object)ImmutableMap.of((Object)"third", (Object)"{{third}}")), (Object)"end", (Object)"awesome", (Object)"third", (Object)"{{end}}");
        String render = this.variableRenderer.render("{{  render(first) | jq(\".second.third\") }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"awesome\"]");
    }

    @Test
    void map() throws IllegalVariableEvaluationException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("string", 1, Float.valueOf(1.123f)), "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars | jq(\".second.string\") }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"string\"]");
        render = this.variableRenderer.render("{{ vars | jq(\".second.string\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("string");
        render = this.variableRenderer.render("{{ vars | jq(\".second.int\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ vars | jq(\".second.float\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1.123");
        render = this.variableRenderer.render("{{ vars | jq(\".second.list\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"string\",1,1.123]");
        render = this.variableRenderer.render("{{ vars | jq(\".second.bool\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("true");
        render = this.variableRenderer.render("{{ vars | jq(\".second.date\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo(date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        render = this.variableRenderer.render("{{ vars | jq(\".second.map\") | first }}", (Map)vars);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"int\":1"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"int\":1"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"float\":1.123"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"string\":\"string\""});
        Assertions.assertThat((String)render).startsWith((CharSequence)"{");
        Assertions.assertThat((String)render).endsWith((CharSequence)"}");
    }

    @Test
    void list() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Arrays.asList(1, 2, 3)));
        String render = this.variableRenderer.render("{{ vars | jq(\".second[]\") }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[1,2,3]");
    }

    @Test
    void typed() throws IllegalVariableEvaluationException {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("string", "string");
        value.put("int", 1);
        value.put("float", Float.valueOf(1.123f));
        value.put("bool", true);
        value.put("null", null);
        ImmutableMap vars = ImmutableMap.of((Object)"vars", value);
        Assertions.assertThat((String)this.variableRenderer.render("{{ vars | jq(\".string\") | first | className }}", (Map)vars)).isEqualTo("java.lang.String");
        Assertions.assertThat((String)this.variableRenderer.render("{{ vars | jq(\".int\") | first | className }}", (Map)vars)).isEqualTo("java.lang.Integer");
        Assertions.assertThat((String)this.variableRenderer.render("{{ vars | jq(\".float\") | first | className }}", (Map)vars)).isEqualTo("java.lang.Float");
        Assertions.assertThat((String)this.variableRenderer.render("{{ vars | jq(\".bool\") | first | className }}", (Map)vars)).isEqualTo("java.lang.Boolean");
        Assertions.assertThat((String)this.variableRenderer.render("{{ vars | jq(\".null\") | first | className }}", (Map)vars)).isEqualTo("");
    }

    @Test
    void object() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"object", Map.of("key", "value"), (Object)"array", (Object)new String[]{"arrayValue"}));
        String render = this.variableRenderer.render("{% set object = vars | jq(\".object\") %}{{object[0].key}}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("value");
        render = this.variableRenderer.render("{% set array = vars | jq(\".array\") %}{{array[0][0]}}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("arrayValue");
    }
}

