/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class KeysFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    KeysFilterTest() {
    }

    @Test
    void map() throws IllegalVariableEvaluationException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("string", 1, Float.valueOf(1.123f)), "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars.second.list | keys }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[0,1,2]");
        render = this.variableRenderer.render("{{ vars.second | keys }}", (Map)vars);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"string\""});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"map\""});
        Assertions.assertThat((int)render.split(",").length).isEqualTo(7);
    }
}

