/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class NumberFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    NumberFilterTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{{ \"12.3\" | number | className }}", Float.class.getName()}), Arguments.of((Object[])new Object[]{"{{ \"2147483647\" | number | className }}", Integer.class.getName()}), Arguments.of((Object[])new Object[]{"{{ \"9223372036854775807\" | number | className }}", Long.class.getName()}), Arguments.of((Object[])new Object[]{"{{ \"9223372036854775807\" | number('BIGDECIMAL') | className }}", BigDecimal.class.getName()}), Arguments.of((Object[])new Object[]{"{{ \"9223372036854775807\" | number('BIGINTEGER') | className }}", BigInteger.class.getName()}), Arguments.of((Object[])new Object[]{"{{ \"9223372036854775807\" | number('DOUBLE') | className }}", Double.class.getName()}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void run(String exp, String expected) throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render(exp, Map.of());
        Assertions.assertThat((String)render).isEqualTo(expected);
    }
}

