/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class SubstringFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    SubstringFilterTest() {
    }

    @Test
    void substringBefore() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ 'a.b.c' | substringBefore('.') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("a");
    }

    @Test
    void substringAfter() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ 'a.b.c' | substringAfter(separator='.') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("b.c");
    }

    @Test
    void substringBeforeLast() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ 'a.b.c' | substringBeforeLast(separator='.') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("a.b");
        render = this.variableRenderer.render("{{ 'a.b.c' | substringBeforeLast('.') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("a.b");
    }

    @Test
    void substringAfterLast() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ 'a.b.c' | substringAfterLast('.') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("c");
    }
}

