/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ToIonFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    ToIonFilterTest() {
    }

    @Test
    void toIonFilter() throws IllegalVariableEvaluationException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("string", 1, Float.valueOf(1.123f)), "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars.second.string | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("\"string\"");
        render = this.variableRenderer.render("{{ vars.second.int | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ vars.second.float | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1.1230000257492065e0");
        render = this.variableRenderer.render("{{ vars.second.list | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"string\",1,1.1230000257492065e0]");
        render = this.variableRenderer.render("{{ vars.second.bool | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("true");
        render = this.variableRenderer.render("{{ vars.second.date | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).startsWith((CharSequence)("ZonedDateTime::\"" + date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        render = this.variableRenderer.render("{{ vars.second.map | toIon }}", (Map)vars);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"int:1"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"float:1.1230000257492065e0"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"string:\"string\""});
        Assertions.assertThat((String)render).startsWith((CharSequence)"{");
        Assertions.assertThat((String)render).endsWith((CharSequence)"}");
        render = this.variableRenderer.render("{{ {\"empty_object\":{}} | toIon }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("{empty_object:{}}");
        render = this.variableRenderer.render("{{ null | toIon }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("null");
    }

    @Test
    void exception() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ | toIon }}", Map.of()));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ {not: json} | toIon }}", Map.of()));
    }
}

