/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ToJsonFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    ToJsonFilterTest() {
    }

    @Test
    void toJsonFilter() throws IllegalVariableEvaluationException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("string", 1, Float.valueOf(1.123f)), "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars.second.string | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("\"string\"");
        render = this.variableRenderer.render("{{ vars.second.int | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ vars.second.float | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1.123");
        render = this.variableRenderer.render("{{ vars.second.list | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("[\"string\",1,1.123]");
        render = this.variableRenderer.render("{{ vars.second.bool | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("true");
        render = this.variableRenderer.render("{{ vars.second.date | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("\"" + date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "\"");
        render = this.variableRenderer.render("{{ vars.second.map | toJson }}", (Map)vars);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"int\":1"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"int\":1"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"float\":1.123"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"string\":\"string\""});
        Assertions.assertThat((String)render).startsWith((CharSequence)"{");
        Assertions.assertThat((String)render).endsWith((CharSequence)"}");
        render = this.variableRenderer.render("{{ {\"empty_object\":{}} | toJson }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("{\"empty_object\":{}}");
        render = this.variableRenderer.render("{{ null | toJson }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("null");
    }

    @Test
    void exception() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ | toJson }}", Map.of()));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ {not: json} | toJson }}", Map.of()));
    }

    @Test
    void jsonFilter() throws IllegalVariableEvaluationException {
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string")));
        String render = this.variableRenderer.render("{{ vars.second.string | json }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("\"string\"");
    }
}

