/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.serializers.JacksonMapper;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ValuesFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    ValuesFilterTest() {
    }

    @Test
    void map() throws IllegalVariableEvaluationException, JsonProcessingException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars.second.map | values }}", (Map)vars);
        List list = (List)JacksonMapper.ofJson().readValue(render, (TypeReference)new TypeReference<List<Object>>(this){});
        Assertions.assertThat((List)list).contains(new Object[]{"string"});
        Assertions.assertThat((List)list).contains(new Object[]{1.123});
        render = this.variableRenderer.render("{{ vars.second | values }}", (Map)vars);
        list = (List)JacksonMapper.ofJson().readValue(render, (TypeReference)new TypeReference<List<Object>>(this){});
        Assertions.assertThat((List)list).contains(new Object[]{"string"});
        Assertions.assertThat((List)list).contains(new Object[]{true});
    }
}

