/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class YamlFilterTest {
    @Inject
    VariableRenderer variableRenderer;

    YamlFilterTest() {
    }

    @Test
    void map() throws IllegalVariableEvaluationException {
        ZonedDateTime date = ZonedDateTime.parse("2013-09-08T16:19:00+02").withZoneSameLocal(ZoneId.systemDefault());
        ImmutableMap vars = ImmutableMap.of((Object)"vars", (Object)ImmutableMap.of((Object)"second", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f), "list", Arrays.asList("string", 1, Float.valueOf(1.123f)), "bool", true, "date", date, "map", Map.of("string", "string", "int", 1, "float", Float.valueOf(1.123f)))));
        String render = this.variableRenderer.render("{{ vars.second.string | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("string\n");
        render = this.variableRenderer.render("{{ vars.second.int | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1\n");
        render = this.variableRenderer.render("{{ vars.second.float | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("1.123\n");
        render = this.variableRenderer.render("{{ vars.second.list | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo(" - string\n - 1\n - 1.123\n");
        render = this.variableRenderer.render("{{ vars.second.bool | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo("true\n");
        render = this.variableRenderer.render("{{ vars.second.date | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).isEqualTo(date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "\n");
        render = this.variableRenderer.render("{{ vars.second.map | yaml }}", (Map)vars);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"int: 1\n"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"int: 1\n"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"float: 1.123\n"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"string: string\n"});
    }
}

