/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.micronaut.context.annotation.Value;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class EncryptDecryptFunctionTest {
    @Inject
    private VariableRenderer variableRenderer;
    @Value(value="${kestra.encryption.secret-key}")
    private String secretKey;

    EncryptDecryptFunctionTest() {
    }

    @Test
    void missingParameter() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{encrypt('toto')}}", Collections.emptyMap()));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{decrypt('toto')}}", Collections.emptyMap()));
    }

    @Test
    void encryptDecrypt() throws IllegalVariableEvaluationException {
        String encrypted = this.variableRenderer.render("{{encrypt(secretKey, 'toto')}}", Map.of("secretKey", this.secretKey));
        Assertions.assertThat((String)encrypted).isNotNull();
        String decrypted = this.variableRenderer.render("{{decrypt(secretKey, '" + encrypted + "')}}", Map.of("secretKey", this.secretKey));
        Assertions.assertThat((String)decrypted).isEqualTo("toto");
    }
}

