/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.runners.VariableRenderer;
import io.micronaut.context.annotation.Property;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.slf4j.event.Level;

@KestraTest
@Property(name="kestra.server-type", value="WORKER")
@Execution(value=ExecutionMode.SAME_THREAD)
class ErrorLogsFunctionTest {
    @Inject
    private LogRepositoryInterface logRepository;
    @Inject
    private VariableRenderer variableRenderer;

    ErrorLogsFunctionTest() {
    }

    @AfterEach
    void tearDown() {
        this.logRepository.deleteByQuery("dev", "execution", null, null, (Level)null, null);
    }

    @Test
    void shouldReturnNothingWhenNoErrors() throws IllegalVariableEvaluationException {
        this.logRepository.save(this.logEntry(Level.INFO, "some log message"));
        Map<String, Map<String, String>> variables = Map.of("flow", Map.of("tenantId", "dev"), "execution", Map.of("id", "execution"));
        String render = this.variableRenderer.render("{{ errorLogs() }}", variables);
        Assertions.assertThat((String)render).isEqualTo("[]");
    }

    @Test
    void shouldReturnErrorsWhenExistsErrors() throws IllegalVariableEvaluationException {
        this.logRepository.save(this.logEntry(Level.INFO, "some log message"));
        this.logRepository.save(this.logEntry(Level.ERROR, "first error message"));
        this.logRepository.save(this.logEntry(Level.ERROR, "second error message"));
        Map<String, Map<String, String>> variables = Map.of("flow", Map.of("tenantId", "dev"), "execution", Map.of("id", "execution"));
        String render = this.variableRenderer.render("{{ errorLogs() }}", variables);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"first error message"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"second error message"});
    }

    private LogEntry logEntry(Level level, String message) {
        return LogEntry.builder().tenantId("dev").namespace("namespace").flowId("flow").executionId("execution").timestamp(Instant.now()).level(level).message(message).build();
    }
}

