/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@KestraTest(rebuildContext=true)
@Execution(value=ExecutionMode.SAME_THREAD)
public class FileSizeFunctionTest {
    private static final String NAMESPACE = "my.namespace";
    private static final String FLOW = "flow";
    private static final String FILE_TEXT = "Hello from a task output";
    private static final String FILE_SIZE = "24";
    @Inject
    StorageInterface storageInterface;
    @Inject
    VariableRenderer variableRenderer;

    @Test
    void returnsCorrectSize_givenStringUri_andCurrentExecution() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI);
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", executionId));
        String size = this.variableRenderer.render("{{ fileSize('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)size).isEqualTo(FILE_SIZE);
    }

    @Test
    void readNamespaceFileWithNamespace() throws IllegalVariableEvaluationException, IOException {
        String namespace = "io.kestra.tests";
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream(FILE_TEXT.getBytes()));
        String render = this.variableRenderer.render("{{ fileSize('" + filePath + "', namespace='" + namespace + "') }}", Map.of(FLOW, Map.of("namespace", "flow.namespace", "tenantId", "main")));
        Assertions.assertThat((String)render).isEqualTo(FILE_SIZE);
    }

    @Test
    void returnsCorrectSize_givenStringUri_andParentExecution() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI);
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", "subflow", "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", IdUtils.create()), "trigger", Map.of("flowId", FLOW, "namespace", NAMESPACE, "executionId", executionId, "tenantId", "main"));
        String size = this.variableRenderer.render("{{ fileSize('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)size).isEqualTo(FILE_SIZE);
    }

    @Test
    void shouldReadFromAnotherExecution() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI);
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", "subflow", "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", IdUtils.create()));
        String size = this.variableRenderer.render("{{ fileSize('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)size).isEqualTo(FILE_SIZE);
    }

    @Test
    void returnsCorrectSize_givenUri_andCurrentExecution() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI);
        Map<String, URI> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", executionId), "file", internalStorageFile);
        String size = this.variableRenderer.render("{{ fileSize(file) }}", variables);
        Assertions.assertThat((String)size).isEqualTo(FILE_SIZE);
    }

    @Test
    void returnsCorrectSize_givenUri_andParentExecution() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI);
        Map<String, URI> variables = Map.of(FLOW, Map.of("id", "subflow", "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", IdUtils.create()), "trigger", Map.of("flowId", FLOW, "namespace", NAMESPACE, "executionId", executionId, "tenantId", "main"), "file", internalStorageFile);
        String size = this.variableRenderer.render("{{ fileSize(file) }}", variables);
        Assertions.assertThat((String)size).isEqualTo(FILE_SIZE);
    }

    @Test
    void shouldFailProcessingUnsupportedScheme() {
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.variableRenderer.render("{{ fileSize('unsupported://path-to/file.txt') }}", variables));
    }

    @Test
    void shouldFailProcessingNotAllowedPath() throws IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> this.variableRenderer.render("{{ fileSize(file) }}", variables));
    }

    @Test
    @Property(name="kestra.local-files.allowed-paths", value="/tmp")
    void shouldSucceedProcessingAllowedFile() throws IllegalVariableEvaluationException, IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ fileSize(file) }}", variables)).isEqualTo("11");
    }

    @Test
    @PropertySource(value={@Property(name="kestra.local-files.allowed-paths", value="/tmp"), @Property(name="kestra.local-files.enable-file-functions", value="false")})
    void shouldFailProcessingAllowedFileIfFileFunctionDisabled() throws IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> this.variableRenderer.render("{{ fileSize(file) }}", variables));
    }

    @Test
    void shouldProcessNamespaceFile() throws IOException, IllegalVariableEvaluationException {
        URI file = this.createNsFile(false);
        Map<String, String> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", "io.kestra.tests", "tenantId", "main"), "execution", Map.of("id", "execution"), "nsfile", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ fileSize(nsfile) }}", variables)).isEqualTo("11");
    }

    @Test
    void shouldProcessNamespaceFileFromAnotherNamespace() throws IOException, IllegalVariableEvaluationException {
        URI file = this.createNsFile(true);
        Map<String, String> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "execution"), "nsfile", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ fileSize(nsfile) }}", variables)).isEqualTo("11");
    }

    private URI createNsFile(boolean nsInAuthority) throws IOException {
        String namespace = "io.kestra.tests";
        String filePath = "%sfile.txt".formatted(IdUtils.create());
        this.storageInterface.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello World".getBytes()));
        return URI.create("nsfile://" + (nsInAuthority ? namespace : "") + "/" + filePath);
    }

    private URI createFile() throws IOException {
        File tempFile = File.createTempFile("%sfile".formatted(IdUtils.create()), ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return tempFile.toPath().toUri();
    }

    private URI getInternalStorageURI(String executionId) {
        return URI.create("/" + NAMESPACE.replace(".", "/") + "/flow/executions/" + executionId + "/tasks/task/" + IdUtils.create() + "/123456.ion");
    }

    private URI getInternalStorageFile(URI internalStorageURI) throws IOException {
        return this.storageInterface.put("main", null, internalStorageURI, (InputStream)new ByteArrayInputStream(FILE_TEXT.getBytes()));
    }
}

