/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FileURIFunctionTest {
    @Inject
    private VariableRenderer variableRenderer;

    FileURIFunctionTest() {
    }

    @Test
    void fileURIFunction() throws IllegalVariableEvaluationException {
        String namespace = "my.namespace";
        String flowId = "flow";
        Map<String, String> variables = Map.of("flow", Map.of("id", flowId, "namespace", namespace), "fileA", "test");
        String render = this.variableRenderer.render("{{ fileURI(fileA) }}", variables);
        Assertions.assertThat((String)render).isEqualTo("kestra:///my/namespace/_files/test");
    }

    @Test
    void fileURIFunctionShouldThrowForIncorrectPath() throws IllegalVariableEvaluationException {
        String namespace = "my.namespace";
        String flowId = "flow";
        Map<String, String> variables = Map.of("flow", Map.of("id", flowId, "namespace", namespace), "fileA", "../test");
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.variableRenderer.render("{{ fileURI(fileA) }}", variables));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("Path must not contain '../'");
    }
}

