/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@KestraTest
class FromIonFunctionTest {
    @Inject
    VariableRenderer variableRenderer;
    @Inject
    StorageInterface storageInterface;

    FromIonFunctionTest() {
    }

    @Test
    void ionDecodeFunction() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ fromIon('{date:2024-04-21T23:00:00.000Z, title:\"Main_Page\",views:109787}').title }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("Main_Page");
        render = this.variableRenderer.render("{{ fromIon(null) }}", Map.of());
        Assertions.assertThat((String)render).isEmpty();
    }

    @Test
    void multiLine() throws IllegalVariableEvaluationException, IOException {
        File tempFile = File.createTempFile(this.getClass().getSimpleName().toLowerCase() + "_", ".trs");
        FileOutputStream output = new FileOutputStream(tempFile);
        for (int i = 0; i < 10; ++i) {
            FileSerde.write((OutputStream)output, (Object)ImmutableMap.of((Object)"id", (Object)i, (Object)"name", (Object)"john"));
        }
        Map<String, Map<String, String>> variables = Map.of("flow", Map.of("id", "test", "namespace", "unit", "tenantId", "main"), "execution", Map.of("id", "id-exec"));
        URI internalStorageURI = URI.create("/unit/test/executions/id-exec/" + IdUtils.create() + ".ion");
        URI internalStorageFile = this.storageInterface.put("main", "unit", internalStorageURI, (InputStream)new FileInputStream(tempFile));
        String render = this.variableRenderer.render("{{ fromIon(read('" + String.valueOf(internalStorageFile) + "'), allRows=true) }}", variables);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"id\":0"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"id\":9"});
        render = this.variableRenderer.render("{{ fromIon(read('" + String.valueOf(internalStorageFile) + "')) }}", variables);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"\"id\":0"});
        MatcherAssert.assertThat((Object)render, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"id\":9")));
    }

    @Test
    void exception() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ fromIon() }}", Map.of()));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ fromIon('{not: ion') }}", Map.of()));
    }
}

