/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FromJsonFunctionTest {
    @Inject
    VariableRenderer variableRenderer;

    FromJsonFunctionTest() {
    }

    @Test
    void fronJsonFunction() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ fromJson('{\"test1\": 1, \"test2\": 2, \"test3\": 3}').test1 }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ fromJson('{\"test1\": [{\"test1\": 666}, 2, 3], \"test2\": 2, \"test3\": 3}').test1[0].test1 }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("666");
        render = this.variableRenderer.render("{{ fromJson('[1, 2, 3]')[0] }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("1");
        render = this.variableRenderer.render("{{ fromJson('{\"empty_object\":{}}') }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("{\"empty_object\":{}}");
        render = this.variableRenderer.render("{{ fromJson(null) }}", Map.of());
        Assertions.assertThat((String)render).isEmpty();
    }

    @Test
    void exception() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ fromJson() }}", Map.of()));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ fromJson('{not: json}') }}", Map.of()));
    }

    @Test
    void jsonFunction() throws IllegalVariableEvaluationException {
        String render = this.variableRenderer.render("{{ json('{\"test1\": 1, \"test2\": 2, \"test3\": 3}').test1 }}", Map.of());
        Assertions.assertThat((String)render).isEqualTo("1");
    }
}

