/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.serializers.JacksonMapper;
import io.pebbletemplates.pebble.error.PebbleException;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.utils.Base64;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@KestraTest
@WireMockTest(httpPort=28182)
@Execution(value=ExecutionMode.SAME_THREAD)
class HttpFunctionTest {
    @Inject
    private VariableRenderer variableRenderer;

    HttpFunctionTest() {
    }

    @Test
    void defaultHttpCall() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ http(url) }}", Map.of("url", "https://dummyjson.com/todos"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rendered.startsWith("{\"todos\":[{"));
    }

    @Test
    void postWithBodyHttpCall() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ http(url,'POST',body=body) }}", Map.of("url", "https://dummyjson.com/todos/add", "body", Map.of("todo", "New todo", "userId", 1, "completed", false)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rendered.contains("\"todo\":\"New todo\""));
    }

    @Test
    void wrongMethod() {
        IllegalVariableEvaluationException exception = (IllegalVariableEvaluationException)Assert.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ http(url) }}", Map.of("url", "https://dummyjson.com/todos/add")));
        Assertions.assertThat((Throwable)exception.getCause()).isInstanceOf(PebbleException.class);
        Assertions.assertThat((String)exception.getCause().getMessage()).isEqualTo("Failed to execute HTTP Request, server respond with status 404 : Not Found ({{ http(url) }}:1)");
    }

    @Test
    void getWithQueryHttpCall() throws IllegalVariableEvaluationException, JsonProcessingException {
        String rendered = this.variableRenderer.render("{{\n  http(\n    url,\n    'GET',\n    {\n      'limit': 2\n    }\n  )\n}}", Map.of("url", "https://dummyjson.com/todos"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((List)JacksonMapper.toMap((String)rendered).get("todos")).size());
    }

    @Test
    void anotherContentTypeAndAccept(WireMockRuntimeInfo wmRuntimeInfo) throws IllegalVariableEvaluationException {
        String responseBody = "response: body\nwith:\n- yaml\n- content\n";
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/yamlApi")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/x-yaml"}).withBody(responseBody)));
        String rendered = this.variableRenderer.render("{{\n    http(\n        url,\n        'POST',\n        body=body,\n        contentType='application/yaml',\n        accept='application/yaml'\n    ).with[0]\n}}", Map.of("url", "http://localhost:28182/yamlApi", "body", Map.of("request", "body", "with", List.of("yaml", "content"))));
        WireMock wireMock = wmRuntimeInfo.getWireMock();
        String receivedRequestBody = ((ServeEvent)wireMock.getServeEvents().getFirst()).getRequest().getBodyAsString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)receivedRequestBody.contains("request: body"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)receivedRequestBody.contains("with:\n- yaml\n- content"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"yaml", (Object)rendered);
    }

    @Test
    void withHeaders() throws IllegalVariableEvaluationException {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/withHeadersApi")).withHeader("custom-header", WireMock.equalTo((String)"custom-value")).withHeader("multiple-value-header", WireMock.havingExactly((String[])new String[]{"value1", "value2"})).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"headers\":\"received\"}")));
        String rendered = this.variableRenderer.render("{{\n    http(\n        url,\n        'POST',\n        headers={\n            'custom-header': 'custom-value',\n            'multiple-value-header': ['value1', 'value2']\n        }\n    )\n}}", Map.of("url", "http://localhost:28182/withHeadersApi"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"headers\":\"received\"}", (Object)rendered);
    }

    @Test
    void withOptions() throws IllegalVariableEvaluationException {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/withBasicAuthApi")).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.encodeBase64String((byte[])"myUser:myPassword".getBytes(StandardCharsets.UTF_8))))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"successfully\":\"authenticated\"}")));
        String rendered = this.variableRenderer.render("{{\n    http(\n        url,\n        'GET',\n        options={\n            'basicAuthUser': user,\n            'basicAuthPassword': password\n        }\n    )\n}}", Map.of("url", "http://localhost:28182/withBasicAuthApi", "user", "myUser", "password", "myPassword"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"successfully\":\"authenticated\"}", (Object)rendered);
    }
}

