/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@KestraTest(rebuildContext=true)
@Execution(value=ExecutionMode.SAME_THREAD)
class IsFileEmptyFunctionTest {
    private static final String NAMESPACE = "my.namespace";
    private static final String FLOW = "flow";
    @Inject
    VariableRenderer variableRenderer;
    @Inject
    StorageInterface storageInterface;

    IsFileEmptyFunctionTest() {
    }

    private URI getInternalStorageURI(String executionId) {
        return URI.create("/" + NAMESPACE.replace(".", "/") + "/flow/executions/" + executionId + "/tasks/task/" + IdUtils.create() + "/123456.ion");
    }

    private URI getInternalStorageFile(URI internalStorageURI, String text) throws IOException {
        return this.storageInterface.put("main", NAMESPACE, internalStorageURI, (InputStream)new ByteArrayInputStream(text.getBytes()));
    }

    @Test
    void shouldReturnFalseForFileWithText() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI, "NOT AN EMPTY FILE");
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", executionId));
        boolean render = Boolean.parseBoolean(this.variableRenderer.render("{{ isFileEmpty('" + String.valueOf(internalStorageFile) + "') }}", variables));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)render);
    }

    @Test
    void readNamespaceFileWithNamespace() throws IllegalVariableEvaluationException, IOException {
        String namespace = "io.kestra.tests";
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("NOT AN EMPTY FILE".getBytes()));
        boolean render = Boolean.parseBoolean(this.variableRenderer.render("{{ isFileEmpty('" + filePath + "', namespace='" + namespace + "') }}", Map.of(FLOW, Map.of("namespace", "flow.namespace", "tenantId", "main"))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)render);
    }

    @Test
    void shouldReturnTrueForEmpty() throws IOException, IllegalVariableEvaluationException {
        String executionId = IdUtils.create();
        URI internalStorageURI = this.getInternalStorageURI(executionId);
        URI internalStorageFile = this.getInternalStorageFile(internalStorageURI, "");
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", NAMESPACE, "tenantId", "main"), "execution", Map.of("id", executionId));
        boolean render = Boolean.parseBoolean(this.variableRenderer.render("{{ isFileEmpty('" + String.valueOf(internalStorageFile) + "') }}", variables));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)render);
    }

    @Test
    void shouldFailProcessingUnsupportedScheme() {
        Map<String, Map<String, String>> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.variableRenderer.render("{{ isFileEmpty('unsupported://path-to/file.txt') }}", variables));
    }

    @Test
    void shouldFailProcessingNotAllowedPath() throws IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> this.variableRenderer.render("{{ isFileEmpty(file) }}", variables));
    }

    @Test
    @Property(name="kestra.local-files.allowed-paths", value="/tmp")
    void shouldSucceedProcessingAllowedFile() throws IllegalVariableEvaluationException, IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ isFileEmpty(file) }}", variables)).isEqualTo("false");
    }

    @Test
    @PropertySource(value={@Property(name="kestra.local-files.allowed-paths", value="/tmp"), @Property(name="kestra.local-files.enable-file-functions", value="false")})
    void shouldFailProcessingAllowedFileIfFileFunctionDisabled() throws IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of(FLOW, Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> this.variableRenderer.render("{{ isFileEmpty(file) }}", variables));
    }

    @Test
    void shouldProcessNamespaceFile() throws IOException, IllegalVariableEvaluationException {
        URI file = this.createNsFile(false);
        Map<String, String> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", "io.kestra.tests", "tenantId", "main"), "execution", Map.of("id", "execution"), "nsfile", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ isFileEmpty(nsfile) }}", variables)).isEqualTo("false");
    }

    @Test
    void shouldProcessNamespaceFileFromAnotherNamespace() throws IOException, IllegalVariableEvaluationException {
        URI file = this.createNsFile(true);
        Map<String, String> variables = Map.of(FLOW, Map.of("id", FLOW, "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "execution"), "nsfile", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ isFileEmpty(nsfile) }}", variables)).isEqualTo("false");
    }

    private URI createNsFile(boolean nsInAuthority) throws IOException {
        String namespace = "io.kestra.tests";
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello World".getBytes()));
        return URI.create("nsfile://" + (nsInAuthority ? namespace : "") + "/" + filePath);
    }

    private URI createFile() throws IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return tempFile.toPath().toUri();
    }
}

