/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class KSUIDFunctionTest {
    @Inject
    VariableRenderer variableRenderer;
    private static final Pattern KSUID_PATTERN = Pattern.compile("^[0-9A-Za-z]{27}$");

    KSUIDFunctionTest() {
    }

    @Test
    void testKsuidGeneration() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ ksuid() }}", Collections.emptyMap());
        Assertions.assertThat((String)rendered).isNotEmpty();
        Assertions.assertThat((boolean)KSUID_PATTERN.matcher(rendered).matches()).isTrue();
    }

    @Test
    void testKsuidUniqueness() throws IllegalVariableEvaluationException {
        String ksuid1 = this.variableRenderer.render("{{ ksuid() }}", Collections.emptyMap());
        String ksuid2 = this.variableRenderer.render("{{ ksuid() }}", Collections.emptyMap());
        Assertions.assertThat((String)ksuid1).isNotEqualTo((Object)ksuid2);
    }
}

