/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.repositories.KvMetadataRepositoryInterface;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.pebble.functions.FunctionTestUtils;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.kv.InternalKVStore;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class KvFunctionTest {
    @Inject
    private KvMetadataRepositoryInterface kvMetadataRepository;
    @Inject
    private StorageInterface storageInterface;
    @Inject
    VariableRenderer variableRenderer;

    @Test
    void shouldGetValueFromKVGivenExistingKey() throws IllegalVariableEvaluationException, IOException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        InternalKVStore kv = new InternalKVStore(tenant, "io.kestra.tests", this.storageInterface, this.kvMetadataRepository);
        kv.put("my-key", new KVValueAndMetadata(null, Map.of("field", "value")));
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "io.kestra.tests");
        String rendered = this.variableRenderer.render("{{ kv('my-key') }}", variables);
        Assertions.assertThat((String)rendered).isEqualTo("{\"field\":\"value\"}");
    }

    @Test
    void shouldGetValueFromKVGivenExistingKeyWithInheritance() throws IllegalVariableEvaluationException, IOException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        InternalKVStore kv = new InternalKVStore(tenant, "my.company", this.storageInterface, this.kvMetadataRepository);
        kv.put("my-key", new KVValueAndMetadata(null, Map.of("field", "value")));
        InternalKVStore firstKv = new InternalKVStore(tenant, "my", this.storageInterface, this.kvMetadataRepository);
        firstKv.put("my-key", new KVValueAndMetadata(null, Map.of("field", "firstValue")));
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "my.company.team");
        String rendered = this.variableRenderer.render("{{ kv('my-key') }}", variables);
        Assertions.assertThat((String)rendered).isEqualTo("{\"field\":\"value\"}");
    }

    @Test
    void shouldNotGetValueFromKVWithGivenNamespaceAndInheritance() throws IOException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        InternalKVStore kv = new InternalKVStore(tenant, "kv", this.storageInterface, this.kvMetadataRepository);
        kv.put("my-key", new KVValueAndMetadata(null, Map.of("field", "value")));
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "my.company.team");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ kv('my-key', namespace='kv.inherited') }}", variables));
    }

    @Test
    void shouldGetValueFromKVGivenExistingAndNamespace() throws IllegalVariableEvaluationException, IOException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        InternalKVStore kv = new InternalKVStore(tenant, "kv", this.storageInterface, this.kvMetadataRepository);
        kv.put("my-key", new KVValueAndMetadata(null, Map.of("field", "value")));
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "io.kestra.tests");
        String rendered = this.variableRenderer.render("{{ kv('my-key', namespace='kv') }}", variables);
        Assertions.assertThat((String)rendered).isEqualTo("{\"field\":\"value\"}");
    }

    @Test
    void shouldGetEmptyGivenNonExistingKeyAndErrorOnMissingFalse() throws IllegalVariableEvaluationException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "io.kestra.tests");
        String rendered = this.variableRenderer.render("{{ kv('my-key', errorOnMissing=false) }}", variables);
        Assertions.assertThat((String)rendered).isEqualTo("");
    }

    @Test
    void shouldThrowOrGetEmptyIfExpiredDependingOnErrorOnMissing() throws IOException, IllegalVariableEvaluationException {
        String tenant = TestsUtils.randomTenant((String[])new String[0]);
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, namespace);
        InternalKVStore kv = new InternalKVStore(tenant, namespace, this.storageInterface, this.kvMetadataRepository);
        kv.put("my-expired-key", new KVValueAndMetadata(new KVMetadata(null, Instant.now().minus(1L, ChronoUnit.HOURS)), (Object)"anyValue"));
        String rendered = this.variableRenderer.render("{{ kv('my-expired-key', errorOnMissing=false) }}", variables);
        Assertions.assertThat((String)rendered).isEqualTo("");
        kv.put("another-expired-key", new KVValueAndMetadata(new KVMetadata(null, Instant.now().minus(1L, ChronoUnit.HOURS)), (Object)"anyValue"));
        IllegalVariableEvaluationException exception = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ kv('another-expired-key') }}", variables));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("io.pebbletemplates.pebble.error.PebbleException: The requested value has expired ({{ kv('another-expired-key') }}:1)");
    }

    @Test
    void shouldFailGivenNonExistingKeyAndErrorOnMissingTrue() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "io.kestra.tests");
        IllegalVariableEvaluationException exception = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ kv('my-key', errorOnMissing=true) }}", variables));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("io.pebbletemplates.pebble.error.PebbleException: The key 'my-key' does not exist in the namespace 'io.kestra.tests'. ({{ kv('my-key', errorOnMissing=true) }}:1)");
    }

    @Test
    void shouldFailGivenNonExistingKeyUsingDefaults() {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        Map<String, Object> variables = FunctionTestUtils.getVariables(tenant, "io.kestra.tests");
        IllegalVariableEvaluationException exception = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ kv('my-key') }}", variables));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("io.pebbletemplates.pebble.error.PebbleException: The key 'my-key' does not exist in the namespace 'io.kestra.tests'. ({{ kv('my-key') }}:1)");
    }
}

