/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class NanoIDFuntionTest {
    @Inject
    VariableRenderer variableRenderer;

    @Test
    void checkStandardNanoId() throws Exception {
        String rendered = this.variableRenderer.render("{{ nanoId() }}", Collections.emptyMap());
        ((AbstractBooleanAssert)Assertions.assertThat((!rendered.isEmpty() ? 1 : 0) != 0).as(rendered, new Object[0])).isTrue();
        Assertions.assertThat((int)rendered.length()).isEqualTo(21L);
    }

    @Test
    void checkDifferentLength() throws Exception {
        String rendered = this.variableRenderer.render("{{ nanoId(length) }}", Map.of("length", 8L));
        ((AbstractBooleanAssert)Assertions.assertThat((!rendered.isEmpty() ? 1 : 0) != 0).as(rendered, new Object[0])).isTrue();
        Assertions.assertThat((int)rendered.length()).isEqualTo(8L);
    }

    @Test
    void checkDifferentAlphabet() throws Exception {
        String rendered = this.variableRenderer.render("{{ nanoId(length,alphabet) }}", Map.of("length", 21L, "alphabet", ":;<=>?@"));
        ((AbstractBooleanAssert)Assertions.assertThat((!rendered.isEmpty() ? 1 : 0) != 0).as(rendered, new Object[0])).isTrue();
        Assertions.assertThat((int)rendered.length()).isEqualTo(21L);
        for (char c : rendered.toCharArray()) {
            Assertions.assertThat((char)c).isGreaterThanOrEqualTo(':');
            Assertions.assertThat((char)c).isLessThanOrEqualTo('@');
        }
    }
}

