/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class RandomIntFunctionTest {
    @Inject
    VariableRenderer variableRenderer;

    RandomIntFunctionTest() {
    }

    @Test
    void missingParameter() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{randomInt(lower)}}", Map.of("lower", 10L)));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{randomInt(upper)}}", Map.of("upper", 1L)));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{randomInt()}}", Collections.emptyMap()));
    }

    @Test
    void testGenerateNumberPositive() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ randomInt(lower, upper) }}", Map.of("lower", 1L, "upper", 10L));
        ((AbstractBooleanAssert)Assertions.assertThat((Long.parseLong(rendered) >= 1L && Long.parseLong(rendered) <= 10L ? 1 : 0) != 0).as(rendered, new Object[0])).isTrue();
    }

    @Test
    void testGenerateNumberPositiveString() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ randomInt(lower, upper) }}", Map.of("lower", "1", "upper", "10")));
    }

    @Test
    void testGenerateNumberUpperLessThanLower() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ randomInt(lower, upper) }}", Map.of("lower", 10L, "upper", 1L)));
    }

    @Test
    void testGenerateNumberNegative() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ randomInt(lower, upper) }}", Map.of("lower", -10L, "upper", -1L));
        ((AbstractBooleanAssert)Assertions.assertThat((Long.parseLong(rendered) >= -10L && Long.parseLong(rendered) <= -1L ? 1 : 0) != 0).as(rendered, new Object[0])).isTrue();
    }

    @Test
    void testGenerateNumberSame() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ randomInt(lower, upper) }}", Map.of("lower", 10L, "upper", 10L));
        ((AbstractBooleanAssert)Assertions.assertThat((Long.parseLong(rendered) == 10L ? 1 : 0) != 0).as(rendered, new Object[0])).isTrue();
    }
}

