/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.pebble.functions.FunctionTestUtils;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@KestraTest(rebuildContext=true)
@Property(name="kestra.server-type", value="WORKER")
@Execution(value=ExecutionMode.SAME_THREAD)
class ReadFileFunctionTest {
    @Inject
    VariableRenderer variableRenderer;
    @Inject
    StorageInterface storageInterface;

    ReadFileFunctionTest() {
    }

    @Test
    void readNamespaceFile() throws IllegalVariableEvaluationException, IOException {
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", "io.kestra.tests", URI.create(StorageContext.namespaceFilePrefix((String)"io.kestra.tests")));
        this.storageInterface.put("main", "io.kestra.tests", URI.create(StorageContext.namespaceFilePrefix((String)"io.kestra.tests") + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello from {{ flow.namespace }}".getBytes()));
        String render = this.variableRenderer.render("{{ render(read('" + filePath + "')) }}", FunctionTestUtils.getVariables());
        Assertions.assertThat((String)render).isEqualTo("Hello from io.kestra.tests");
    }

    @Test
    void readNamespaceFileFromURI() throws IllegalVariableEvaluationException, IOException {
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", "io.kestra.tests", URI.create(StorageContext.namespaceFilePrefix((String)"io.kestra.tests")));
        this.storageInterface.put("main", "io.kestra.tests", URI.create(StorageContext.namespaceFilePrefix((String)"io.kestra.tests") + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello from {{ flow.namespace }}".getBytes()));
        Map<String, Object> variables = FunctionTestUtils.getVariablesWithExecution("io.kestra.tests");
        String render = this.variableRenderer.render("{{ render(read(fileURI('" + filePath + "'))) }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from io.kestra.tests");
    }

    @Test
    void readNamespaceFileWithNamespace() throws IllegalVariableEvaluationException, IOException {
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", "io.kestra.tests", URI.create(StorageContext.namespaceFilePrefix((String)"io.kestra.tests")));
        this.storageInterface.put("main", "io.kestra.tests", URI.create(StorageContext.namespaceFilePrefix((String)"io.kestra.tests") + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello but not from flow.namespace".getBytes()));
        String render = this.variableRenderer.render("{{ read('" + filePath + "', namespace='io.kestra.tests') }}", FunctionTestUtils.getVariables("different.namespace"));
        Assertions.assertThat((String)render).isEqualTo("Hello but not from flow.namespace");
    }

    @Test
    void readUnknownNamespaceFile() {
        IllegalVariableEvaluationException illegalVariableEvaluationException = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ read('unknown.txt') }}", FunctionTestUtils.getVariables()));
        Assertions.assertThat(illegalVariableEvaluationException.getCause().getCause().getClass()).isEqualTo(FileNotFoundException.class);
    }

    @Test
    void readInternalStorageFile() throws IOException, IllegalVariableEvaluationException {
        String namespace = "my.namespace";
        String flowId = "flow";
        String executionId = IdUtils.create();
        URI internalStorageURI = URI.create("/" + namespace.replace(".", "/") + "/" + flowId + "/executions/" + executionId + "/tasks/task/" + IdUtils.create() + "/123456.ion");
        URI internalStorageFile = this.storageInterface.put("main", namespace, internalStorageURI, (InputStream)new ByteArrayInputStream("Hello from a task output".getBytes()));
        Map<String, Object> variables = FunctionTestUtils.getVariablesWithExecution(namespace, executionId);
        String render = this.variableRenderer.render("{{ read('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from a task output");
        variables = Map.of("flow", Map.of("id", "subflow", "namespace", namespace, "tenantId", "main"), "execution", Map.of("id", IdUtils.create()), "trigger", Map.of("flowId", flowId, "namespace", namespace, "executionId", executionId, "tenantId", "main"));
        render = this.variableRenderer.render("{{ read('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from a task output");
    }

    @Test
    void readInternalStorageURI() throws IOException, IllegalVariableEvaluationException {
        String namespace = "my.namespace";
        String flowId = "flow";
        String executionId = IdUtils.create();
        URI internalStorageURI = URI.create("/" + namespace.replace(".", "/") + "/" + flowId + "/executions/" + executionId + "/tasks/task/" + IdUtils.create() + "/123456.ion");
        URI internalStorageFile = this.storageInterface.put("main", namespace, internalStorageURI, (InputStream)new ByteArrayInputStream("Hello from a task output".getBytes()));
        Map<String, Object> variables = Map.of("flow", Map.of("id", flowId, "namespace", namespace, "tenantId", "main"), "execution", Map.of("id", executionId), "file", internalStorageFile);
        String render = this.variableRenderer.render("{{ read(file) }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from a task output");
        variables = Map.of("flow", Map.of("id", "subflow", "namespace", namespace, "tenantId", "main"), "execution", Map.of("id", IdUtils.create()), "trigger", Map.of("flowId", flowId, "namespace", namespace, "executionId", executionId, "tenantId", "main"));
        render = this.variableRenderer.render("{{ read('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from a task output");
    }

    @Test
    void readInternalStorageFileFromAnotherExecution() throws IOException, IllegalVariableEvaluationException {
        String namespace = "my.namespace";
        String flowId = "flow";
        String executionId = IdUtils.create();
        URI internalStorageURI = URI.create("/" + namespace.replace(".", "/") + "/" + flowId + "/executions/" + executionId + "/tasks/task/" + IdUtils.create() + "/123456.ion");
        URI internalStorageFile = this.storageInterface.put("main", namespace, internalStorageURI, (InputStream)new ByteArrayInputStream("Hello from a task output".getBytes()));
        Map<String, Object> variables = FunctionTestUtils.getVariablesWithExecution("notme", "notme");
        String render = this.variableRenderer.render("{{ read('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from a task output");
    }

    @Test
    @Property(name="kestra.server-type", value="EXECUTOR")
    @Disabled(value="Moved on the next release")
    void readFailOnNonWorkerNodes() {
        IllegalVariableEvaluationException exception = (IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ read('unknown.txt') }}", Map.of("flow", Map.of("namespace", "io.kestra.tests"))));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"The 'read' function can only be used in the Worker as it access the internal storage."});
    }

    @Test
    void shouldFailProcessingUnsupportedScheme() {
        Map<String, Object> variables = FunctionTestUtils.getVariablesWithExecution("notme", "notme");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.variableRenderer.render("{{ read('unsupported://path-to/file.txt') }}", variables));
    }

    @Test
    void shouldFailProcessingNotAllowedPath() throws IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of("flow", Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> this.variableRenderer.render("{{ read(file) }}", variables));
    }

    @Test
    @Property(name="kestra.local-files.allowed-paths", value="/tmp")
    void shouldSucceedProcessingAllowedFile() throws IllegalVariableEvaluationException, IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of("flow", Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ read(file) }}", variables)).isEqualTo("Hello World");
    }

    @Test
    @PropertySource(value={@Property(name="kestra.local-files.allowed-paths", value="/tmp"), @Property(name="kestra.local-files.enable-file-functions", value="false")})
    void shouldFailProcessingAllowedFileIfFileFunctionDisabled() throws IOException {
        URI file = this.createFile();
        Map<String, String> variables = Map.of("flow", Map.of("id", "notme", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "file", file.toString());
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> this.variableRenderer.render("{{ read(file) }}", variables));
    }

    @Test
    void shouldProcessNamespaceFile() throws IOException, IllegalVariableEvaluationException {
        URI file = this.createNsFile(false);
        Map<String, String> variables = Map.of("flow", Map.of("id", "flow", "namespace", "io.kestra.tests", "tenantId", "main"), "execution", Map.of("id", "execution"), "nsfile", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ read(nsfile) }}", variables)).isEqualTo("Hello World");
    }

    @Test
    void shouldProcessNamespaceFileFromAnotherNamespace() throws IOException, IllegalVariableEvaluationException {
        URI file = this.createNsFile(true);
        Map<String, String> variables = Map.of("flow", Map.of("id", "flow", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "execution"), "nsfile", file.toString());
        Assertions.assertThat((String)this.variableRenderer.render("{{ read(nsfile) }}", variables)).isEqualTo("Hello World");
    }

    @Test
    void shouldReadChildFileEvenIfTrigger() throws IOException, IllegalVariableEvaluationException {
        String namespace = "my.namespace";
        String flowId = "flow";
        String executionId = IdUtils.create();
        URI internalStorageURI = URI.create("/" + namespace.replace(".", "/") + "/" + flowId + "/executions/" + executionId + "/tasks/task/" + IdUtils.create() + "/123456.ion");
        URI internalStorageFile = this.storageInterface.put("main", namespace, internalStorageURI, (InputStream)new ByteArrayInputStream("Hello from a task output".getBytes()));
        Map<String, Map<String, String>> variables = Map.of("flow", Map.of("id", "flow", "namespace", "notme", "tenantId", "main"), "execution", Map.of("id", "notme"), "trigger", Map.of("namespace", "notme", "flowId", "parent", "executionId", "parent"));
        String render = this.variableRenderer.render("{{ read('" + String.valueOf(internalStorageFile) + "') }}", variables);
        Assertions.assertThat((String)render).isEqualTo("Hello from a task output");
    }

    private URI createFile() throws IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return tempFile.toPath().toUri();
    }

    private URI createNsFile(boolean nsInAuthority) throws IOException {
        String namespace = "io.kestra.tests";
        String filePath = "file.txt";
        this.storageInterface.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storageInterface.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello World".getBytes()));
        return URI.create("nsfile://" + (nsInAuthority ? namespace : "") + "/" + filePath);
    }
}

