/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class RenderFunctionTest {
    @Inject
    VariableRenderer variableRenderer;

    RenderFunctionTest() {
    }

    @Test
    void shouldRenderForString() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ render(input) }}", Map.of("input", "test"));
        Assertions.assertEquals((Object)"test", (Object)rendered);
    }

    @Test
    void shouldRenderForInteger() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ render(input) }}", Map.of("input", 42));
        Assertions.assertEquals((Object)"42", (Object)rendered);
    }

    @Test
    void shouldRenderForLong() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ render(input) }}", Map.of("input", 42L));
        Assertions.assertEquals((Object)"42", (Object)rendered);
    }

    @Test
    void shouldRenderForBoolean() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ render(input) }}", Map.of("input", true));
        Assertions.assertEquals((Object)"true", (Object)rendered);
    }

    @Test
    void shouldRenderForNull() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ render(input) }}", (Map)new HashMap<String, Object>(){
            {
                this.put("input", null);
            }
        });
        Assertions.assertEquals((Object)"", (Object)rendered);
    }

    @Test
    void shouldRenderForDateTime() throws IllegalVariableEvaluationException {
        Instant now = Instant.now();
        LocalDateTime datetime = LocalDateTime.ofInstant(now, ZoneOffset.UTC);
        String rendered = this.variableRenderer.render("{{ render(input) }}", Map.of("input", datetime));
        Assertions.assertEquals((Object)datetime.toString(), (Object)rendered);
    }

    @Test
    void shouldRenderForDuration() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ render(input) }}", Map.of("input", Duration.ofSeconds(5L)));
        Assertions.assertEquals((Object)Duration.ofSeconds(5L).toString(), (Object)rendered);
    }
}

