/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class RenderOncerFunctionTest {
    @Inject
    VariableRenderer variableRenderer;

    RenderOncerFunctionTest() {
    }

    @Test
    void noRenderNeeded() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ renderOnce(input) }}", Map.of("input", "test"));
        Assertions.assertEquals((Object)"test", (Object)rendered);
    }

    @Test
    void oneLayerRender() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ renderOnce(input) }}", Map.of("input", "{{someOtherVar}}", "someOtherVar", "test"));
        Assertions.assertEquals((Object)"test", (Object)rendered);
    }

    @Test
    void twoLayerRender() throws IllegalVariableEvaluationException {
        String rendered = this.variableRenderer.render("{{ renderOnce(input) }}", Map.of("input", "{{someOtherVar}}", "someOtherVar", "{{yetAnotherVar}}", "yetAnotherVar", "test"));
        Assertions.assertEquals((Object)"{{yetAnotherVar}}", (Object)rendered);
    }
}

