/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.VariableRenderer;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class YamlFunctionTest {
    @Inject
    VariableRenderer variableRenderer;

    YamlFunctionTest() {
    }

    @Test
    void fromString() throws IllegalVariableEvaluationException {
        ImmutableMap runContext = ImmutableMap.of((Object)"yaml", (Object)"# comment\nstring: string\nint: 123\nbool: true\nfloat: 1.23\ninstant: \"1918-02-24T00:00:00Z\"\ndate: \"1991-08-20\"\ntime: \"23:59:59\"\nduration: \"PT5M6S\"\n'null':\nobject:\n  key: \"value\"\n  child:\n    key: \"value\"\narray:\n  - string\nreference: &ref\n    key: reference\ndefault: *ref\n");
        String render = this.variableRenderer.render("{{ yaml(yaml).string }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("string");
        render = this.variableRenderer.render("{{ yaml(yaml).int }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("123");
        render = this.variableRenderer.render("{{ yaml(yaml).bool }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("true");
        render = this.variableRenderer.render("{{ yaml(yaml).float }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("1.23");
        render = this.variableRenderer.render("{{ yaml(yaml).instant }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("1918-02-24T00:00:00Z");
        render = this.variableRenderer.render("{{ yaml(yaml).date }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("1991-08-20");
        render = this.variableRenderer.render("{{ yaml(yaml).time }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("23:59:59");
        render = this.variableRenderer.render("{{ yaml(yaml).object.child.key }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("value");
        render = this.variableRenderer.render("{{ yaml(yaml).array[0] }}", (Map)runContext);
        Assertions.assertThat((String)render).isEqualTo("string");
    }
}

