/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.secret;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.secret.SecretNotFoundException;
import io.kestra.core.secret.SecretService;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
public class SecretFunctionTest {
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> logQueue;
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    private SecretService secretService;
    @Inject
    VariableRenderer variableRenderer;

    @Test
    @LoadFlows(value={"flows/valids/secrets.yaml"})
    @EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="SECRET_MY_SECRET", matches=".*"), @EnabledIfEnvironmentVariable(named="SECRET_NEW_LINE", matches=".*")})
    void getSecret() throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "secrets");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"secretValue");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(2)).getOutputs().get((Object)"value")).isEqualTo((Object)"passwordveryveryveyrlongpasswordveryveryveyrlongpasswordveryveryveyrlongpasswordveryveryveyrlongpasswordveryveryveyrlong");
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().get(3)).getOutputs().get((Object)"value")).isEqualTo((Object)"secretValue");
        Assertions.assertThat((Map)((TaskRun)execution.getTaskRunList().get(4)).getOutputs()).isEmpty();
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().get(4)).getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        LogEntry matchingLog = TestsUtils.awaitLog(logs, logEntry -> logEntry.getTaskId() != null && logEntry.getTaskId().equals("log-secret"));
        receive.blockLast();
        Assertions.assertThat((String)matchingLog.getMessage()).contains(new CharSequence[]{"***"});
    }

    @Test
    void shouldGetSecretGivenExistingSubKey() throws IllegalVariableEvaluationException {
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        Assertions.assertThat((String)this.variableRenderer.render("{{ secret('json-secret', subkey='string') }}", context)).isEqualTo("value");
        Assertions.assertThat((String)this.variableRenderer.render("{{ secret('json-secret', subkey='number') }}", context)).isEqualTo("42");
        Assertions.assertThat((String)this.variableRenderer.render("{{ secret('json-secret', subkey='array') }}", context)).isEqualTo("[\"one\",\"two\",\"three\"]");
        Assertions.assertThat((String)this.variableRenderer.render("{{ secret('json-secret', subkey='object') }}", context)).isEqualTo("{\"f1\":\"value1\",\"f2\":\"value2\"}");
        Assertions.assertThat((String)this.variableRenderer.render("{{ secret('json-secret', subkey='boolean') }}", context)).isEqualTo("true");
    }

    @Test
    void shouldFailedGivenNonExistingSubKey() {
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        Throwable cause = ((IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ secret('json-secret', subkey='missing') }}", context))).getCause();
        Assertions.assertThat((String)cause.getMessage()).isEqualTo("Cannot find secret sub-key 'missing' in secret 'json-secret'. ({{ secret('json-secret', subkey='missing') }}:1)");
    }

    @Test
    void shouldFailedGivenExistingButInvalidSubKey() {
        Map<String, Map<String, String>> context = Map.of("flow", Map.of("namespace", "io.kestra.unittest"));
        Throwable cause = ((IllegalVariableEvaluationException)org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> this.variableRenderer.render("{{ secret('string-secret', subkey='???') }}", context))).getCause();
        Assertions.assertThat((String)cause.getMessage()).isEqualTo("Failed to read secret sub-key '???' from secret 'string-secret'. Ensure the secret contains valid JSON value. ({{ secret('string-secret', subkey='???') }}:1)");
    }

    @Test
    void getUnknownSecret() {
        SecretNotFoundException exception = (SecretNotFoundException)org.junit.jupiter.api.Assertions.assertThrows(SecretNotFoundException.class, () -> this.secretService.findSecret(null, null, "unknown_secret_key"));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("Cannot find secret for key 'unknown_secret_key'.");
    }

    @MockBean(value=SecretService.class)
    public static class TestSecretService
    extends SecretService {
        private static final Map<String, String> SECRETS = Map.of("io.kestra.unittest.json-secret", "{\n\"string\": \"value\",\n\"number\": 42,\n\"boolean\": true,\n\"array\": [\"one\", \"two\", \"three\"],\n\"object\": {\"f1\": \"value1\", \"f2\": \"value2\"}\n}\n", "io.kestra.unittest.string-secret", "string-value");

        public String findSecret(String tenantId, String namespace, String key) throws SecretNotFoundException, IOException {
            Optional<String> optional = Optional.ofNullable(SECRETS.get(namespace + "." + key));
            if (optional.isPresent()) {
                return optional.get();
            }
            return super.findSecret(tenantId, namespace, key);
        }
    }
}

