/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.serializers.FileSerde;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

class FileSerdeTest {
    FileSerdeTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{"hello", null}), Arguments.of((Object[])new Object[]{1, null}), Arguments.of((Object[])new Object[]{Float.valueOf(1.0f), 1.0}), Arguments.of((Object[])new Object[]{1.25, null}), Arguments.of((Object[])new Object[]{LocalDate.parse("2008-12-25"), null}), Arguments.of((Object[])new Object[]{Date.from(Instant.parse("2008-12-25T15:30:00.123Z")), Instant.parse("2008-12-25T15:30:00.123Z")}), Arguments.of((Object[])new Object[]{LocalDateTime.parse("2008-12-25T15:30:00.123"), null}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2008-12-25T15:30:00.123+01:00"), null}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2008-12-25T15:30:00.123+01:00").toOffsetDateTime(), null}), Arguments.of((Object[])new Object[]{LocalTime.parse("15:30:00.123456"), null}), Arguments.of((Object[])new Object[]{Instant.parse("2008-12-25T15:30:00.123Z"), null}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2008-12-25T15:30:00.123+01:00"), null}), Arguments.of((Object[])new Object[]{Arrays.asList(1.1, 2.2, 3.3), null}), Arguments.of((Object[])new Object[]{Map.of("x", 4.1, "y", 0.1, "z", 3.1), null}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void ion(Object value, Object resultValue) throws IOException {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("key", value);
        File tempFile = File.createTempFile(this.getClass().getSimpleName().toLowerCase() + "_", ".ion");
        try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
            FileSerde.write((OutputStream)outputStream, object);
        }
        BufferedReader inputStream = new BufferedReader(new FileReader(tempFile));
        Map result = (Map)Flux.create((Consumer)FileSerde.reader((BufferedReader)inputStream), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER).map(o -> (Map)o).blockFirst();
        if (value instanceof Map) {
            MatcherAssert.assertThat(((Map)object.get("key")).entrySet(), (Matcher)Matchers.everyItem((Matcher)Matchers.in(((Map)result.get("key")).entrySet())));
            MatcherAssert.assertThat(((Map)result.get("key")).entrySet(), (Matcher)Matchers.everyItem((Matcher)Matchers.in(((Map)object.get("key")).entrySet())));
        } else if (value instanceof Collections) {
            Assertions.assertThat((List)((List)object.get("key"))).containsExactlyInAnyOrder(new Object[]{(List)result.get("key")});
        } else {
            Assertions.assertThat(result.get("key")).isEqualTo(resultValue != null ? resultValue : object.get("key"));
        }
    }

    @Test
    void readMax() throws IOException {
        File tempFile = File.createTempFile(this.getClass().getSimpleName().toLowerCase() + "_", ".ion");
        try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
            FileSerde.write((OutputStream)outputStream, Map.of("key1", "value1"));
            FileSerde.write((OutputStream)outputStream, Map.of("key2", "value2"));
            FileSerde.write((OutputStream)outputStream, Map.of("key3", "value3"));
        }
        BufferedReader inputStream = new BufferedReader(new FileReader(tempFile));
        ArrayList list = new ArrayList();
        FileSerde.reader((BufferedReader)inputStream, (int)2, row -> list.add(row));
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    @Test
    void readAll_fromEmptySource() throws IOException {
        Path inputTempFilePath = FileSerdeTest.createTempFile();
        List outputValues = (List)FileSerde.readAll((Reader)Files.newBufferedReader(inputTempFilePath)).collectList().block();
        Assertions.assertThat((List)outputValues).isEmpty();
    }

    @Test
    void readAll_fromSingleValuedSource() throws IOException {
        Path inputTempFilePath = FileSerdeTest.createTempFile();
        List<String> inputLines = List.of("{id:1,value:\"value1\"}");
        Files.write(inputTempFilePath, inputLines, new OpenOption[0]);
        List outputValues = (List)FileSerde.readAll((Reader)Files.newBufferedReader(inputTempFilePath), (TypeReference)new TypeReference<SimpleEntry>(this){}).collectList().block();
        Assertions.assertThat((List)outputValues).hasSize(1);
        Assertions.assertThat((Object)((SimpleEntry)outputValues.getFirst())).isEqualTo((Object)new SimpleEntry(1L, "value1"));
    }

    @Test
    void readAll_fromMultiValuedSource() throws IOException {
        Path inputTempFilePath = FileSerdeTest.createTempFile();
        List<String> inputLines = List.of("{id:1,value:\"value1\"}", "{id:2,value:\"value2\"}", "{id:3,value:\"value3\"}");
        Files.write(inputTempFilePath, inputLines, new OpenOption[0]);
        List outputValues = (List)FileSerde.readAll((Reader)Files.newBufferedReader(inputTempFilePath), (TypeReference)new TypeReference<SimpleEntry>(this){}).collectList().block();
        Assertions.assertThat((List)outputValues).hasSize(3);
        Assertions.assertThat((Object)((SimpleEntry)outputValues.getFirst())).isEqualTo((Object)new SimpleEntry(1L, "value1"));
        Assertions.assertThat((Object)((SimpleEntry)outputValues.get(1))).isEqualTo((Object)new SimpleEntry(2L, "value2"));
        Assertions.assertThat((Object)((SimpleEntry)outputValues.get(2))).isEqualTo((Object)new SimpleEntry(3L, "value3"));
    }

    @Test
    void writeAll_fromEmptySource() throws IOException {
        Path outputTempFilePath = FileSerdeTest.createTempFile();
        Long outputCount = (Long)FileSerde.writeAll((Writer)Files.newBufferedWriter(outputTempFilePath, new OpenOption[0]), (Flux)Flux.empty()).block();
        Assertions.assertThat((Long)outputCount).isEqualTo(0L);
    }

    @Test
    void writeAll_fromSingleValuedSource() throws IOException {
        Path outputTempFilePath = FileSerdeTest.createTempFile();
        List<SimpleEntry> inputValues = List.of(new SimpleEntry(1L, "value1"));
        Long outputCount = (Long)FileSerde.writeAll((Writer)Files.newBufferedWriter(outputTempFilePath, new OpenOption[0]), (Flux)Flux.fromIterable(inputValues)).block();
        Assertions.assertThat((Long)outputCount).isEqualTo(1L);
        List<String> outputLines = Files.readAllLines(outputTempFilePath);
        Assertions.assertThat(outputLines).hasSize(1);
        Assertions.assertThat((String)outputLines.getFirst()).isEqualTo("{id:1,value:\"value1\"}");
    }

    @Test
    void writeAll_fromMultiValuedSource() throws IOException {
        Path outputTempFilePath = FileSerdeTest.createTempFile();
        List<SimpleEntry> inputValues = List.of(new SimpleEntry(1L, "value1"), new SimpleEntry(2L, "value2"), new SimpleEntry(3L, "value3"));
        Long outputCount = (Long)FileSerde.writeAll((Writer)Files.newBufferedWriter(outputTempFilePath, new OpenOption[0]), (Flux)Flux.fromIterable(inputValues)).block();
        Assertions.assertThat((Long)outputCount).isEqualTo(3L);
        List<String> outputLines = Files.readAllLines(outputTempFilePath);
        Assertions.assertThat(outputLines).hasSize(3);
        Assertions.assertThat((String)outputLines.getFirst()).isEqualTo("{id:1,value:\"value1\"}");
        Assertions.assertThat((String)outputLines.get(1)).isEqualTo("{id:2,value:\"value2\"}");
        Assertions.assertThat((String)outputLines.get(2)).isEqualTo("{id:3,value:\"value3\"}");
    }

    @Test
    void writeAll_fromReadAll() throws IOException {
        Path inputTempFilePath = FileSerdeTest.createTempFile();
        Path outputTempFilePath = FileSerdeTest.createTempFile();
        List<String> inputLines = List.of("{id:1,value:\"value1\"}", "{id:2,value:\"value2\"}", "{id:3,value:\"value3\"}");
        Files.write(inputTempFilePath, inputLines, new OpenOption[0]);
        Flux inputFlux = FileSerde.readAll((Reader)Files.newBufferedReader(inputTempFilePath));
        Long outputCount = (Long)FileSerde.writeAll((Writer)Files.newBufferedWriter(outputTempFilePath, new OpenOption[0]), (Flux)inputFlux).block();
        Assertions.assertThat((Long)outputCount).isEqualTo(3L);
        List<String> outputLines = Files.readAllLines(outputTempFilePath);
        Assertions.assertThat(outputLines).isEqualTo(inputLines);
    }

    private static Path createTempFile() throws IOException {
        return Files.createTempFile(FileSerdeTest.class.getSimpleName().toLowerCase() + "_", ".ion", new FileAttribute[0]);
    }

    private record SimpleEntry(long id, String value) {
    }
}

