/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.serializers.JacksonMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultTimeZone;

class JacksonMapperTest {
    JacksonMapperTest() {
    }

    Pojo pojo() {
        return new Pojo("te\n\nst", Instant.parse("2013-09-08T16:19:12Z"), ZonedDateTime.parse("2013-09-08T16:19:12+03:00"), null);
    }

    @Test
    @DefaultTimeZone(value="Europe/Athens")
    void json() throws IOException {
        ObjectMapper mapper = JacksonMapper.ofJson().copy().setTimeZone(TimeZone.getDefault());
        Pojo original = this.pojo();
        String s = mapper.writeValueAsString((Object)original);
        Pojo deserialize = (Pojo)mapper.readValue(s, Pojo.class);
        this.test(original, deserialize);
    }

    @Test
    @DefaultTimeZone(value="Europe/Athens")
    void ion() throws IOException {
        ObjectMapper mapper = JacksonMapper.ofIon();
        Pojo original = this.pojo();
        String s = mapper.writeValueAsString((Object)original);
        Assertions.assertThat((String)s).contains(new CharSequence[]{"nullable:null"});
        Pojo deserialize = (Pojo)mapper.readValue(s, Pojo.class);
        this.test(original, deserialize);
    }

    @Test
    void toList() throws JsonProcessingException {
        String list = "[1, 2, 3]";
        List integerList = JacksonMapper.toList((String)list);
        Assertions.assertThat((int)integerList.size()).isEqualTo(3);
        Assertions.assertThat((List)integerList).containsExactlyInAnyOrder(new Object[]{1, 2, 3});
    }

    @Test
    void toMap() throws JsonProcessingException {
        Assertions.assertThat((Map)JacksonMapper.toMap((String)"{\n    \"some\": \"property\",\n    \"another\": \"property\"\n}")).isEqualTo(Map.of("some", "property", "another", "property"));
    }

    void test(Pojo original, Pojo deserialize) {
        Assertions.assertThat((String)deserialize.getString()).isEqualTo(original.getString());
        Assertions.assertThat((long)deserialize.getInstant().toEpochMilli()).isEqualTo(original.getInstant().toEpochMilli());
        Assertions.assertThat((String)deserialize.getInstant().toString()).isEqualTo(original.getInstant().toString());
        Assertions.assertThat((long)deserialize.getZonedDateTime().toEpochSecond()).isEqualTo(original.getZonedDateTime().toEpochSecond());
        Assertions.assertThat((Comparable)deserialize.getZonedDateTime().getOffset()).isEqualTo((Object)original.getZonedDateTime().getOffset());
    }

    @Test
    void shouldComputeDiffGivenCreatedObject() {
        Pair value = JacksonMapper.getBiDirectionalDiffs(null, (Object)new DummyObject("value"));
        Assertions.assertThat((String)((JsonNode)value.getLeft()).toString()).isEqualTo("[{\"op\":\"replace\",\"path\":\"\",\"value\":{\"value\":\"value\"}}]");
        Assertions.assertThat((String)((JsonNode)value.getRight()).toString()).isEqualTo("[{\"op\":\"replace\",\"path\":\"\",\"value\":null}]");
    }

    @Test
    void shouldComputeDiffGivenUpdatedObject() {
        Pair value = JacksonMapper.getBiDirectionalDiffs((Object)new DummyObject("before"), (Object)new DummyObject("after"));
        Assertions.assertThat((String)((JsonNode)value.getLeft()).toString()).isEqualTo("[{\"op\":\"replace\",\"path\":\"/value\",\"value\":\"after\"}]");
        Assertions.assertThat((String)((JsonNode)value.getRight()).toString()).isEqualTo("[{\"op\":\"replace\",\"path\":\"/value\",\"value\":\"before\"}]");
    }

    @Test
    void shouldComputeDiffGivenDeletedObject() {
        Pair value = JacksonMapper.getBiDirectionalDiffs((Object)new DummyObject("value"), null);
        Assertions.assertThat((String)((JsonNode)value.getLeft()).toString()).isEqualTo("[{\"op\":\"replace\",\"path\":\"\",\"value\":null}]");
        Assertions.assertThat((String)((JsonNode)value.getRight()).toString()).isEqualTo("[{\"op\":\"replace\",\"path\":\"\",\"value\":{\"value\":\"value\"}}]");
    }

    public static class Pojo {
        private String string;
        private Instant instant;
        private ZonedDateTime zonedDateTime;
        private String nullable;

        @Generated
        public String getString() {
            return this.string;
        }

        @Generated
        public Instant getInstant() {
            return this.instant;
        }

        @Generated
        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        @Generated
        public String getNullable() {
            return this.nullable;
        }

        @Generated
        public Pojo() {
        }

        @ConstructorProperties(value={"string", "instant", "zonedDateTime", "nullable"})
        @Generated
        public Pojo(String string, Instant instant, ZonedDateTime zonedDateTime, String nullable) {
            this.string = string;
            this.instant = instant;
            this.zonedDateTime = zonedDateTime;
            this.nullable = nullable;
        }
    }

    private record DummyObject(String value) {
    }
}

