/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.junit.annotations.KestraTest;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ObjectMapperFactoryTest {
    @Inject
    ObjectMapper objectMapper;

    ObjectMapperFactoryTest() {
    }

    @Test
    void serialize() throws JsonProcessingException {
        Bean b = new Bean();
        b.setIntChange(1);
        b.setIntegerChange(1);
        b.setBoolChangeTrue(false);
        b.setBoolChangeFalse(true);
        b.setBooleanChangeTrue(false);
        b.setBooleanChangeFalse(true);
        b.setStringChange("foo");
        b.setDuration(Duration.parse("PT5M"));
        b.setZonedDateTime(ZonedDateTime.parse("2013-09-08T16:19:12.000000+02:00"));
        String s = this.objectMapper.writeValueAsString((Object)b);
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"intNull\":0"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"intDefault\":0"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"intChange\":1"});
        Assertions.assertThat((String)s).doesNotContain(new CharSequence[]{"\"integerNull\":"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"integerDefault\":0"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"integerChange\":1"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"boolNull\":false"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"boolDefaultTrue\":true"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"boolChangeTrue\":false"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"boolDefaultFalse\":false"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"boolChangeTrue\":false"});
        Assertions.assertThat((String)s).doesNotContain(new CharSequence[]{"\"booleanNull\":"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"booleanDefaultTrue\":true"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"booleanChangeTrue\":false"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"booleanDefaultFalse\":false"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"booleanChangeTrue\":false"});
        Assertions.assertThat((String)s).doesNotContain(new CharSequence[]{"\"stringNull\":"});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"stringDefault\":\"bla\""});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"stringChange\":\"foo\""});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"duration\":\"PT5M\""});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"zonedDateTime\":\"2013-09-08T16:19:12+02:00\""});
    }

    @Test
    void deserialize() throws JsonProcessingException {
        Bean bean = (Bean)this.objectMapper.readValue("{\"boolChangeFalse\":true,\"boolChangeTrue\":false,\"booleanChangeFalse\":true,\"booleanChangeTrue\":false,\"duration\":\"PT5M\",\"intChange\":1,\"integerChange\":1,\"stringChange\":\"foo\",\"zonedDateTime\":\"2013-09-08T16:19:12+02:00\"}", Bean.class);
        Assertions.assertThat((int)bean.intNull).isZero();
        Assertions.assertThat((int)bean.intDefault).isZero();
        Assertions.assertThat((int)bean.intChange).isEqualTo(1);
        Assertions.assertThat((Integer)bean.integerNull).isNull();
        Assertions.assertThat((Integer)bean.integerDefault).isZero();
        Assertions.assertThat((Integer)bean.integerChange).isEqualTo(1);
        Assertions.assertThat((boolean)bean.boolNull).isFalse();
        Assertions.assertThat((boolean)bean.boolDefaultTrue).isTrue();
        Assertions.assertThat((boolean)bean.boolChangeTrue).isFalse();
        Assertions.assertThat((boolean)bean.boolDefaultFalse).isFalse();
        Assertions.assertThat((boolean)bean.boolChangeFalse).isTrue();
        Assertions.assertThat((Boolean)bean.booleanNull).isNull();
        Assertions.assertThat((Boolean)bean.booleanDefaultTrue).isTrue();
        Assertions.assertThat((Boolean)bean.booleanChangeTrue).isFalse();
        Assertions.assertThat((Boolean)bean.booleanDefaultFalse).isFalse();
        Assertions.assertThat((Boolean)bean.booleanChangeFalse).isTrue();
        Assertions.assertThat((String)bean.stringNull).isNull();
        Assertions.assertThat((String)bean.stringDefault).isEqualTo("bla");
        Assertions.assertThat((String)bean.stringChange).isEqualTo("foo");
        Assertions.assertThat((Duration)bean.duration).isEqualTo((Object)Duration.parse("PT5M"));
    }

    @JsonPropertyOrder(alphabetic=true)
    public static class Bean {
        private int intNull;
        private int intDefault = 0;
        private int intChange = 0;
        private Integer integerNull;
        private Integer integerDefault = 0;
        private Integer integerChange = 0;
        private boolean boolNull;
        private boolean boolDefaultTrue = true;
        private boolean boolChangeTrue = true;
        private boolean boolDefaultFalse = false;
        private boolean boolChangeFalse = false;
        private Boolean booleanNull;
        private Boolean booleanDefaultTrue = true;
        private Boolean booleanChangeTrue = true;
        private Boolean booleanDefaultFalse = false;
        private Boolean booleanChangeFalse = false;
        private String stringNull;
        private String stringDefault = "bla";
        private String stringChange = "bla";
        private Duration duration;
        private ZonedDateTime zonedDateTime;

        @Generated
        public int getIntNull() {
            return this.intNull;
        }

        @Generated
        public int getIntDefault() {
            return this.intDefault;
        }

        @Generated
        public int getIntChange() {
            return this.intChange;
        }

        @Generated
        public Integer getIntegerNull() {
            return this.integerNull;
        }

        @Generated
        public Integer getIntegerDefault() {
            return this.integerDefault;
        }

        @Generated
        public Integer getIntegerChange() {
            return this.integerChange;
        }

        @Generated
        public boolean isBoolNull() {
            return this.boolNull;
        }

        @Generated
        public boolean isBoolDefaultTrue() {
            return this.boolDefaultTrue;
        }

        @Generated
        public boolean isBoolChangeTrue() {
            return this.boolChangeTrue;
        }

        @Generated
        public boolean isBoolDefaultFalse() {
            return this.boolDefaultFalse;
        }

        @Generated
        public boolean isBoolChangeFalse() {
            return this.boolChangeFalse;
        }

        @Generated
        public Boolean getBooleanNull() {
            return this.booleanNull;
        }

        @Generated
        public Boolean getBooleanDefaultTrue() {
            return this.booleanDefaultTrue;
        }

        @Generated
        public Boolean getBooleanChangeTrue() {
            return this.booleanChangeTrue;
        }

        @Generated
        public Boolean getBooleanDefaultFalse() {
            return this.booleanDefaultFalse;
        }

        @Generated
        public Boolean getBooleanChangeFalse() {
            return this.booleanChangeFalse;
        }

        @Generated
        public String getStringNull() {
            return this.stringNull;
        }

        @Generated
        public String getStringDefault() {
            return this.stringDefault;
        }

        @Generated
        public String getStringChange() {
            return this.stringChange;
        }

        @Generated
        public Duration getDuration() {
            return this.duration;
        }

        @Generated
        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        @Generated
        public void setIntNull(int intNull) {
            this.intNull = intNull;
        }

        @Generated
        public void setIntDefault(int intDefault) {
            this.intDefault = intDefault;
        }

        @Generated
        public void setIntChange(int intChange) {
            this.intChange = intChange;
        }

        @Generated
        public void setIntegerNull(Integer integerNull) {
            this.integerNull = integerNull;
        }

        @Generated
        public void setIntegerDefault(Integer integerDefault) {
            this.integerDefault = integerDefault;
        }

        @Generated
        public void setIntegerChange(Integer integerChange) {
            this.integerChange = integerChange;
        }

        @Generated
        public void setBoolNull(boolean boolNull) {
            this.boolNull = boolNull;
        }

        @Generated
        public void setBoolDefaultTrue(boolean boolDefaultTrue) {
            this.boolDefaultTrue = boolDefaultTrue;
        }

        @Generated
        public void setBoolChangeTrue(boolean boolChangeTrue) {
            this.boolChangeTrue = boolChangeTrue;
        }

        @Generated
        public void setBoolDefaultFalse(boolean boolDefaultFalse) {
            this.boolDefaultFalse = boolDefaultFalse;
        }

        @Generated
        public void setBoolChangeFalse(boolean boolChangeFalse) {
            this.boolChangeFalse = boolChangeFalse;
        }

        @Generated
        public void setBooleanNull(Boolean booleanNull) {
            this.booleanNull = booleanNull;
        }

        @Generated
        public void setBooleanDefaultTrue(Boolean booleanDefaultTrue) {
            this.booleanDefaultTrue = booleanDefaultTrue;
        }

        @Generated
        public void setBooleanChangeTrue(Boolean booleanChangeTrue) {
            this.booleanChangeTrue = booleanChangeTrue;
        }

        @Generated
        public void setBooleanDefaultFalse(Boolean booleanDefaultFalse) {
            this.booleanDefaultFalse = booleanDefaultFalse;
        }

        @Generated
        public void setBooleanChangeFalse(Boolean booleanChangeFalse) {
            this.booleanChangeFalse = booleanChangeFalse;
        }

        @Generated
        public void setStringNull(String stringNull) {
            this.stringNull = stringNull;
        }

        @Generated
        public void setStringDefault(String stringDefault) {
            this.stringDefault = stringDefault;
        }

        @Generated
        public void setStringChange(String stringChange) {
            this.stringChange = stringChange;
        }

        @Generated
        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        @Generated
        public void setZonedDateTime(ZonedDateTime zonedDateTime) {
            this.zonedDateTime = zonedDateTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bean)) {
                return false;
            }
            Bean other = (Bean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIntNull() != other.getIntNull()) {
                return false;
            }
            if (this.getIntDefault() != other.getIntDefault()) {
                return false;
            }
            if (this.getIntChange() != other.getIntChange()) {
                return false;
            }
            if (this.isBoolNull() != other.isBoolNull()) {
                return false;
            }
            if (this.isBoolDefaultTrue() != other.isBoolDefaultTrue()) {
                return false;
            }
            if (this.isBoolChangeTrue() != other.isBoolChangeTrue()) {
                return false;
            }
            if (this.isBoolDefaultFalse() != other.isBoolDefaultFalse()) {
                return false;
            }
            if (this.isBoolChangeFalse() != other.isBoolChangeFalse()) {
                return false;
            }
            Integer this$integerNull = this.getIntegerNull();
            Integer other$integerNull = other.getIntegerNull();
            if (this$integerNull == null ? other$integerNull != null : !((Object)this$integerNull).equals(other$integerNull)) {
                return false;
            }
            Integer this$integerDefault = this.getIntegerDefault();
            Integer other$integerDefault = other.getIntegerDefault();
            if (this$integerDefault == null ? other$integerDefault != null : !((Object)this$integerDefault).equals(other$integerDefault)) {
                return false;
            }
            Integer this$integerChange = this.getIntegerChange();
            Integer other$integerChange = other.getIntegerChange();
            if (this$integerChange == null ? other$integerChange != null : !((Object)this$integerChange).equals(other$integerChange)) {
                return false;
            }
            Boolean this$booleanNull = this.getBooleanNull();
            Boolean other$booleanNull = other.getBooleanNull();
            if (this$booleanNull == null ? other$booleanNull != null : !((Object)this$booleanNull).equals(other$booleanNull)) {
                return false;
            }
            Boolean this$booleanDefaultTrue = this.getBooleanDefaultTrue();
            Boolean other$booleanDefaultTrue = other.getBooleanDefaultTrue();
            if (this$booleanDefaultTrue == null ? other$booleanDefaultTrue != null : !((Object)this$booleanDefaultTrue).equals(other$booleanDefaultTrue)) {
                return false;
            }
            Boolean this$booleanChangeTrue = this.getBooleanChangeTrue();
            Boolean other$booleanChangeTrue = other.getBooleanChangeTrue();
            if (this$booleanChangeTrue == null ? other$booleanChangeTrue != null : !((Object)this$booleanChangeTrue).equals(other$booleanChangeTrue)) {
                return false;
            }
            Boolean this$booleanDefaultFalse = this.getBooleanDefaultFalse();
            Boolean other$booleanDefaultFalse = other.getBooleanDefaultFalse();
            if (this$booleanDefaultFalse == null ? other$booleanDefaultFalse != null : !((Object)this$booleanDefaultFalse).equals(other$booleanDefaultFalse)) {
                return false;
            }
            Boolean this$booleanChangeFalse = this.getBooleanChangeFalse();
            Boolean other$booleanChangeFalse = other.getBooleanChangeFalse();
            if (this$booleanChangeFalse == null ? other$booleanChangeFalse != null : !((Object)this$booleanChangeFalse).equals(other$booleanChangeFalse)) {
                return false;
            }
            String this$stringNull = this.getStringNull();
            String other$stringNull = other.getStringNull();
            if (this$stringNull == null ? other$stringNull != null : !this$stringNull.equals(other$stringNull)) {
                return false;
            }
            String this$stringDefault = this.getStringDefault();
            String other$stringDefault = other.getStringDefault();
            if (this$stringDefault == null ? other$stringDefault != null : !this$stringDefault.equals(other$stringDefault)) {
                return false;
            }
            String this$stringChange = this.getStringChange();
            String other$stringChange = other.getStringChange();
            if (this$stringChange == null ? other$stringChange != null : !this$stringChange.equals(other$stringChange)) {
                return false;
            }
            Duration this$duration = this.getDuration();
            Duration other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
                return false;
            }
            ZonedDateTime this$zonedDateTime = this.getZonedDateTime();
            ZonedDateTime other$zonedDateTime = other.getZonedDateTime();
            return !(this$zonedDateTime == null ? other$zonedDateTime != null : !((Object)this$zonedDateTime).equals(other$zonedDateTime));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bean;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIntNull();
            result = result * 59 + this.getIntDefault();
            result = result * 59 + this.getIntChange();
            result = result * 59 + (this.isBoolNull() ? 79 : 97);
            result = result * 59 + (this.isBoolDefaultTrue() ? 79 : 97);
            result = result * 59 + (this.isBoolChangeTrue() ? 79 : 97);
            result = result * 59 + (this.isBoolDefaultFalse() ? 79 : 97);
            result = result * 59 + (this.isBoolChangeFalse() ? 79 : 97);
            Integer $integerNull = this.getIntegerNull();
            result = result * 59 + ($integerNull == null ? 43 : ((Object)$integerNull).hashCode());
            Integer $integerDefault = this.getIntegerDefault();
            result = result * 59 + ($integerDefault == null ? 43 : ((Object)$integerDefault).hashCode());
            Integer $integerChange = this.getIntegerChange();
            result = result * 59 + ($integerChange == null ? 43 : ((Object)$integerChange).hashCode());
            Boolean $booleanNull = this.getBooleanNull();
            result = result * 59 + ($booleanNull == null ? 43 : ((Object)$booleanNull).hashCode());
            Boolean $booleanDefaultTrue = this.getBooleanDefaultTrue();
            result = result * 59 + ($booleanDefaultTrue == null ? 43 : ((Object)$booleanDefaultTrue).hashCode());
            Boolean $booleanChangeTrue = this.getBooleanChangeTrue();
            result = result * 59 + ($booleanChangeTrue == null ? 43 : ((Object)$booleanChangeTrue).hashCode());
            Boolean $booleanDefaultFalse = this.getBooleanDefaultFalse();
            result = result * 59 + ($booleanDefaultFalse == null ? 43 : ((Object)$booleanDefaultFalse).hashCode());
            Boolean $booleanChangeFalse = this.getBooleanChangeFalse();
            result = result * 59 + ($booleanChangeFalse == null ? 43 : ((Object)$booleanChangeFalse).hashCode());
            String $stringNull = this.getStringNull();
            result = result * 59 + ($stringNull == null ? 43 : $stringNull.hashCode());
            String $stringDefault = this.getStringDefault();
            result = result * 59 + ($stringDefault == null ? 43 : $stringDefault.hashCode());
            String $stringChange = this.getStringChange();
            result = result * 59 + ($stringChange == null ? 43 : $stringChange.hashCode());
            Duration $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            ZonedDateTime $zonedDateTime = this.getZonedDateTime();
            result = result * 59 + ($zonedDateTime == null ? 43 : ((Object)$zonedDateTime).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ObjectMapperFactoryTest.Bean(intNull=" + this.getIntNull() + ", intDefault=" + this.getIntDefault() + ", intChange=" + this.getIntChange() + ", integerNull=" + this.getIntegerNull() + ", integerDefault=" + this.getIntegerDefault() + ", integerChange=" + this.getIntegerChange() + ", boolNull=" + this.isBoolNull() + ", boolDefaultTrue=" + this.isBoolDefaultTrue() + ", boolChangeTrue=" + this.isBoolChangeTrue() + ", boolDefaultFalse=" + this.isBoolDefaultFalse() + ", boolChangeFalse=" + this.isBoolChangeFalse() + ", booleanNull=" + this.getBooleanNull() + ", booleanDefaultTrue=" + this.getBooleanDefaultTrue() + ", booleanChangeTrue=" + this.getBooleanChangeTrue() + ", booleanDefaultFalse=" + this.getBooleanDefaultFalse() + ", booleanChangeFalse=" + this.getBooleanChangeFalse() + ", stringNull=" + this.getStringNull() + ", stringDefault=" + this.getStringDefault() + ", stringChange=" + this.getStringChange() + ", duration=" + String.valueOf(this.getDuration()) + ", zonedDateTime=" + String.valueOf(this.getZonedDateTime()) + ")";
        }

        @Generated
        public Bean() {
        }
    }
}

