/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.retrys.Constant;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

@KestraTest
class YamlParserTest {
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    @Inject
    private ModelValidator modelValidator;

    YamlParserTest() {
    }

    @Test
    void parse() {
        Flow flow = this.parse("flows/valids/full.yaml");
        Assertions.assertThat((String)flow.getId()).isEqualTo("full");
        Assertions.assertThat((int)flow.getTasks().size()).isEqualTo(5);
        Task optionals = (Task)flow.getTasks().get(2);
        Assertions.assertThat((Object)optionals.getTimeout()).isEqualTo((Object)Property.builder().expression("PT60M").build());
        Assertions.assertThat((String)optionals.getRetry().getType()).isEqualTo("constant");
        Assertions.assertThat((Integer)optionals.getRetry().getMaxAttempts()).isEqualTo(5);
        Assertions.assertThat((long)((Constant)optionals.getRetry()).getInterval().getSeconds()).isEqualTo(900L);
    }

    @Test
    void parseString() throws IOException {
        Flow flow = this.parseString("flows/valids/full.yaml");
        Assertions.assertThat((String)flow.getId()).isEqualTo("full");
        Assertions.assertThat((int)flow.getTasks().size()).isEqualTo(5);
        Task optionals = (Task)flow.getTasks().get(2);
        Assertions.assertThat((Object)optionals.getTimeout()).isEqualTo((Object)Property.builder().expression("PT60M").build());
        Assertions.assertThat((String)optionals.getRetry().getType()).isEqualTo("constant");
        Assertions.assertThat((Integer)optionals.getRetry().getMaxAttempts()).isEqualTo(5);
        Assertions.assertThat((long)((Constant)optionals.getRetry()).getInterval().getSeconds()).isEqualTo(900L);
    }

    @Test
    void allFlowable() {
        Flow flow = this.parse("flows/valids/all-flowable.yaml");
        Assertions.assertThat((String)flow.getId()).isEqualTo("all-flowable");
        Assertions.assertThat((int)flow.getTasks().size()).isEqualTo(4);
    }

    @Test
    void validation() {
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.modelValidator.validate((Object)this.parse("flows/invalids/invalid.yaml")));
        try {
            this.parse("flows/invalids/invalid.yaml");
        }
        catch (ConstraintViolationException e) {
            Assertions.assertThat((int)e.getConstraintViolations().size()).isEqualTo(4);
        }
    }

    @Test
    void empty() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.modelValidator.validate((Object)this.parse("flows/invalids/empty.yaml")));
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolation)new ArrayList(exception.getConstraintViolations()).getFirst()).getMessage()).isEqualTo("must not be empty");
    }

    @Test
    void inputsFailed() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.modelValidator.validate((Object)this.parse("flows/invalids/inputs.yaml")));
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(2);
        exception.getConstraintViolations().forEach(c -> Assertions.assertThat((String)c.getMessage()).satisfiesAnyOf(new ThrowingConsumer[]{arg -> Assertions.assertThat((String)arg).isEqualTo("Invalid type: null"), arg -> Assertions.assertThat((String)arg).contains(new CharSequence[]{"missing type id property 'type' (for POJO property 'inputs')"})}));
    }

    @Test
    void inputs() {
        Flow flow = this.parse("flows/valids/inputs.yaml");
        Assertions.assertThat((int)flow.getInputs().size()).isEqualTo(29);
        Assertions.assertThat((long)flow.getInputs().stream().filter(Input::getRequired).count()).isEqualTo(11L);
        Assertions.assertThat((long)flow.getInputs().stream().filter(r -> r.getRequired() == false).count()).isEqualTo(18L);
        Assertions.assertThat((long)flow.getInputs().stream().filter(r -> r.getDefaults() != null).count()).isEqualTo(3L);
        Assertions.assertThat((long)flow.getInputs().stream().filter(r -> {
            StringInput stringInput;
            return r instanceof StringInput && (stringInput = (StringInput)r).getValidator() != null;
        }).count()).isEqualTo(1L);
    }

    @Test
    void inputsOld() {
        Flow flow = this.parse("flows/tests/inputs-old.yaml");
        Assertions.assertThat((int)flow.getInputs().size()).isEqualTo(1);
        Assertions.assertThat((String)((Input)flow.getInputs().getFirst()).getId()).isEqualTo("myInput");
        Assertions.assertThat((Comparable)((Input)flow.getInputs().getFirst()).getType()).isEqualTo((Object)Type.STRING);
    }

    @Test
    void inputsBadType() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.parse("flows/invalids/inputs-bad-type.yaml"));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Invalid type: FOO"});
    }

    @Test
    void listeners() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.modelValidator.validate((Object)this.parse("flows/invalids/listener.yaml")));
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(2);
        Assertions.assertThat((String)((ConstraintViolation)new ArrayList(exception.getConstraintViolations()).getFirst()).getMessage()).contains(new CharSequence[]{"must not be empty"});
        Assertions.assertThat((String)((ConstraintViolation)new ArrayList(exception.getConstraintViolations()).get(1)).getMessage()).isEqualTo("must not be empty");
    }

    @Test
    void serialization() throws IOException {
        Flow flow = this.parse("flows/valids/minimal.yaml");
        String s = MAPPER.writeValueAsString((Object)flow);
        Assertions.assertThat((String)s).isEqualTo("{\"id\":\"minimal\",\"namespace\":\"io.kestra.tests\",\"revision\":2,\"disabled\":false,\"deleted\":false,\"labels\":[{\"key\":\"system.readOnly\",\"value\":\"true\"},{\"key\":\"existing\",\"value\":\"label\"}],\"tasks\":[{\"id\":\"date\",\"type\":\"io.kestra.plugin.core.debug.Return\",\"format\":\"{{taskrun.startDate}}\"}]}");
    }

    @Test
    void noDefault() throws IOException {
        Flow flow = this.parse("flows/valids/parallel.yaml");
        String s = MAPPER.writeValueAsString((Object)flow);
        Assertions.assertThat((String)s).doesNotContain(new CharSequence[]{"\"-c\""});
        Assertions.assertThat((String)s).contains(new CharSequence[]{"\"deleted\":false"});
    }

    @Test
    void invalidTask() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.parse("flows/invalids/invalid-task.yaml"));
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(2);
        Assertions.assertThat((String)exception.getConstraintViolations().stream().filter(e -> e.getMessage().contains("Invalid type")).findFirst().orElseThrow().getMessage()).contains(new CharSequence[]{"Invalid type: io.kestra.plugin.core.debug.MissingOne"});
    }

    @Test
    void invalidProperty() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.parse("flows/invalids/invalid-property.yaml"));
        Assertions.assertThat((String)exception.getMessage()).startsWith((CharSequence)"Unrecognized field \"invalid\" (class io.kestra.plugin.core.debug.Return), not marked as ignorable");
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolation)exception.getConstraintViolations().iterator().next()).getPropertyPath().toString()).isEqualTo("io.kestra.core.models.flows.Flow[\"tasks\"]->java.util.ArrayList[0]->io.kestra.plugin.core.debug.Return[\"invalid\"]");
    }

    @Test
    void invalidPropertyOk() throws IOException {
        URL resource = TestsUtils.class.getClassLoader().getResource("flows/invalids/invalid-property.yaml");
        assert (resource != null);
        File file = new File(resource.getFile());
        String flowSource = Files.readString(file.toPath(), Charset.defaultCharset());
        TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(this){};
        Map flow = (Map)JacksonMapper.ofYaml().readValue(flowSource, (TypeReference)TYPE_REFERENCE);
        Flow parse = (Flow)YamlParser.parse((Map)flow, Flow.class, (Boolean)false);
        Assertions.assertThat((String)parse.getId()).isEqualTo("duplicate");
    }

    @Test
    void invalidParallel() {
        Flow parse = this.parse("flows/invalids/invalid-parallel.yaml");
        Optional valid = this.modelValidator.isValid((Object)parse);
        Assertions.assertThat((boolean)valid.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)((Object)valid.get())).getConstraintViolations().size()).isEqualTo(10);
        Assertions.assertThat((long)new ArrayList(((ConstraintViolationException)((Object)valid.get())).getConstraintViolations()).stream().filter(r -> r.getMessage().contains("must not be empty")).count()).isEqualTo(3L);
    }

    @Test
    void duplicateKey() {
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.parse("flows/invalids/duplicate-key.yaml"));
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolation)new ArrayList(exception.getConstraintViolations()).getFirst()).getMessage()).contains(new CharSequence[]{"Duplicate field 'variables.tf'"});
    }

    private Flow parse(String path) {
        URL resource = TestsUtils.class.getClassLoader().getResource(path);
        assert (resource != null);
        File file = new File(resource.getFile());
        return (Flow)YamlParser.parse((File)file, Flow.class);
    }

    private Flow parseString(String path) throws IOException {
        URL resource = TestsUtils.class.getClassLoader().getResource(path);
        assert (resource != null);
        String input = Files.readString(Path.of(resource.getPath(), new String[0]), Charset.defaultCharset());
        return (Flow)YamlParser.parse((String)input, Flow.class);
    }
}

