/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.server.ServerConfig;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceType;
import io.kestra.core.server.WorkerTaskRestartStrategy;
import io.kestra.core.utils.IdUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ServiceInstanceTest {
    public static final ServerConfig CONFIG = new ServerConfig(Duration.ZERO, WorkerTaskRestartStrategy.AFTER_TERMINATION_GRACE_PERIOD, new ServerConfig.Liveness(Boolean.valueOf(true), Duration.ZERO, Duration.ofSeconds(10L), Duration.ZERO, Duration.ZERO));

    ServiceInstanceTest() {
    }

    @Test
    void shouldGetFalseForRunningAndNotTimeout() {
        Instant now = Instant.now();
        ServiceInstance instance = new ServiceInstance(IdUtils.create(), ServiceType.WORKER, Service.ServiceState.RUNNING, null, now.minus(Duration.ofSeconds(5L)), now.minus(Duration.ofSeconds(5L)), null, CONFIG, null, Set.of());
        Assertions.assertFalse((boolean)instance.isSessionTimeoutElapsed(now));
    }

    @Test
    void shouldGetTrueForRunningAndTimeout() {
        Instant now = Instant.now();
        ServiceInstance instance = new ServiceInstance(IdUtils.create(), ServiceType.WORKER, Service.ServiceState.RUNNING, null, now.minus(Duration.ofSeconds(20L)), now.minus(Duration.ofSeconds(20L)), null, CONFIG, null, Set.of());
        Assertions.assertTrue((boolean)instance.isSessionTimeoutElapsed(now));
    }

    @Test
    void shouldUpdateGivenReason() {
        Instant now = Instant.now();
        ServiceInstance instance = new ServiceInstance(IdUtils.create(), ServiceType.WORKER, Service.ServiceState.RUNNING, null, now, now, List.of(), CONFIG, null, Set.of());
        ServiceInstance result = instance.state(Service.ServiceState.DISCONNECTED, now, "Disconnected");
        Assertions.assertNotEquals((Object)instance, (Object)result);
        Assertions.assertEquals(List.of(new ServiceInstance.TimestampedEvent(now, "Disconnected", "service.state.updated", Service.ServiceState.DISCONNECTED)), (Object)result.events());
    }

    @Test
    void shouldGroupInstanceGivenAnExistingProperty() {
        List<ServiceInstance> instances = List.of(ServiceInstanceTest.createServiceInstanceWithProperties(Map.of("prop", "A")), ServiceInstanceTest.createServiceInstanceWithProperties(Map.of("prop", "A")), ServiceInstanceTest.createServiceInstanceWithProperties(Map.of("prop", "B")), ServiceInstanceTest.createServiceInstanceWithProperties(Map.of()));
        Map grouped = ServiceInstance.groupByProperty(instances, (String)"prop");
        Assertions.assertEquals((int)grouped.size(), (int)2);
        Assertions.assertEquals((int)((List)grouped.get("A")).size(), (int)2);
        Assertions.assertEquals((int)((List)grouped.get("B")).size(), (int)1);
    }

    private static ServiceInstance createServiceInstanceWithProperties(Map<String, Object> properties) {
        Instant now = Instant.now();
        return new ServiceInstance(IdUtils.create(), ServiceType.WORKER, Service.ServiceState.RUNNING, null, now, now, List.of(), CONFIG, properties, Set.of());
    }
}

