/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.server.LocalServiceStateFactory;
import io.kestra.core.server.ServerConfig;
import io.kestra.core.server.ServerInstance;
import io.kestra.core.server.ServerInstanceFactory;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceLivenessManager;
import io.kestra.core.server.ServiceLivenessUpdater;
import io.kestra.core.server.ServiceRegistry;
import io.kestra.core.server.ServiceStateChangeEvent;
import io.kestra.core.server.ServiceStateTransition;
import io.kestra.core.server.ServiceType;
import io.kestra.core.server.WorkerTaskRestartStrategy;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Network;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class ServiceLivenessManagerTest {
    private static final Duration DEFAULT_DURATION = Duration.ofSeconds(5L);
    @Mock
    public ServiceLivenessUpdater serviceLivenessUpdater;
    @Captor
    ArgumentCaptor<ServiceInstance> workerInstanceCaptor;
    private ServiceLivenessManager serviceLivenessManager;
    @Mock
    private ServiceLivenessManager.OnStateTransitionFailureCallback onStateTransitionFailureCallback;

    @BeforeEach
    void beforeEach() {
        KestraContext kestraContext = (KestraContext)Mockito.mock(KestraContext.class);
        ServerConfig config = new ServerConfig(Duration.ZERO, WorkerTaskRestartStrategy.AFTER_TERMINATION_GRACE_PERIOD, new ServerConfig.Liveness(Boolean.valueOf(true), Duration.ZERO, DEFAULT_DURATION, DEFAULT_DURATION, DEFAULT_DURATION));
        KestraContext context = (KestraContext)Mockito.mock(KestraContext.class);
        KestraContext.setContext((KestraContext)context);
        Mockito.when((Object)context.getServerType()).thenReturn((Object)ServerType.INDEXER);
        this.serviceLivenessManager = new ServiceLivenessManager(config, new ServiceRegistry(), new LocalServiceStateFactory(config, new ServerInstanceFactory(context, null)), new ServerInstanceFactory(kestraContext, null), this.serviceLivenessUpdater, this.onStateTransitionFailureCallback);
    }

    @Test
    void shouldSaveWorkerInstanceOnRunningStateChange() {
        Service service = ServiceLivenessManagerTest.newServiceForState(Service.ServiceState.CREATED);
        ServiceStateChangeEvent event = new ServiceStateChangeEvent(service);
        this.serviceLivenessManager.onServiceStateChangeEvent(event);
        ((ServiceLivenessUpdater)Mockito.verify((Object)this.serviceLivenessUpdater, (VerificationMode)Mockito.only())).update((ServiceInstance)this.workerInstanceCaptor.capture());
        ServiceInstance value = (ServiceInstance)this.workerInstanceCaptor.getValue();
        Assertions.assertEquals((Object)Service.ServiceState.CREATED, (Object)value.state());
        Assertions.assertEquals((Object)value, this.serviceLivenessManager.allServiceInstances().getFirst());
    }

    @Test
    void shouldUpdateStateOnScheduleForSucceedTransition() {
        Service running = ServiceLivenessManagerTest.newServiceForState(Service.ServiceState.RUNNING);
        this.serviceLivenessManager.updateServiceInstance(running, ServiceLivenessManagerTest.serviceInstanceFor(running));
        Service terminating = ServiceLivenessManagerTest.newServiceForState(Service.ServiceState.TERMINATING);
        ServiceInstance instance = ServiceLivenessManagerTest.serviceInstanceFor(terminating);
        ServiceStateTransition.Response response = new ServiceStateTransition.Response(ServiceStateTransition.Result.SUCCEEDED, instance);
        Mockito.when((Object)this.serviceLivenessUpdater.update((ServiceInstance)Mockito.any(ServiceInstance.class), (Service.ServiceState)Mockito.any(Service.ServiceState.class))).thenReturn((Object)response);
        this.serviceLivenessManager.onSchedule(Instant.now());
        Assertions.assertEquals((Object)instance, this.serviceLivenessManager.allServiceInstances().getFirst());
        ((ServiceLivenessManager.OnStateTransitionFailureCallback)Mockito.verify((Object)this.onStateTransitionFailureCallback, (VerificationMode)Mockito.never())).execute((Instant)Mockito.any(), (Service)Mockito.any(), (ServiceInstance)Mockito.any(), Mockito.eq((boolean)true));
    }

    @Test
    void shouldRunOnStateTransitionFailureForFailedTransition() {
        Service running = ServiceLivenessManagerTest.newServiceForState(Service.ServiceState.RUNNING);
        this.serviceLivenessManager.updateServiceInstance(running, ServiceLivenessManagerTest.serviceInstanceFor(running));
        Service disconnecting = ServiceLivenessManagerTest.newServiceForState(Service.ServiceState.TERMINATING);
        ServiceInstance instance = ServiceLivenessManagerTest.serviceInstanceFor(disconnecting);
        ServiceStateTransition.Response response = new ServiceStateTransition.Response(ServiceStateTransition.Result.FAILED, instance);
        Mockito.when((Object)this.serviceLivenessUpdater.update((ServiceInstance)Mockito.any(ServiceInstance.class), (Service.ServiceState)Mockito.any(Service.ServiceState.class))).thenReturn((Object)response);
        this.serviceLivenessManager.onSchedule(Instant.now());
        Assertions.assertEquals((Object)instance, this.serviceLivenessManager.allServiceInstances().getFirst());
        ((ServiceLivenessManager.OnStateTransitionFailureCallback)Mockito.verify((Object)this.onStateTransitionFailureCallback, (VerificationMode)Mockito.only())).execute((Instant)Mockito.any(), (Service)Mockito.any(), (ServiceInstance)Mockito.any(), Mockito.eq((boolean)true));
    }

    @Test
    void shouldNotRunOnStateTransitionFailureForAbortedTransition() {
        Service running = ServiceLivenessManagerTest.newServiceForState(Service.ServiceState.RUNNING);
        this.serviceLivenessManager.updateServiceInstance(running, ServiceLivenessManagerTest.serviceInstanceFor(running));
        Mockito.when((Object)this.serviceLivenessUpdater.update((ServiceInstance)Mockito.any(ServiceInstance.class), (Service.ServiceState)Mockito.any(Service.ServiceState.class))).thenReturn((Object)new ServiceStateTransition.Response(ServiceStateTransition.Result.ABORTED));
        this.serviceLivenessManager.onSchedule(Instant.now());
        ((ServiceLivenessManager.OnStateTransitionFailureCallback)Mockito.verify((Object)this.onStateTransitionFailureCallback, (VerificationMode)Mockito.never())).execute((Instant)Mockito.any(), (Service)Mockito.any(), (ServiceInstance)Mockito.any(), Mockito.eq((boolean)true));
    }

    public static Service newServiceForState(final Service.ServiceState state) {
        return new Service(){
            private final String id = IdUtils.create();

            public String getId() {
                return this.id;
            }

            public ServiceType getType() {
                return ServiceType.WORKER;
            }

            public Service.ServiceState getState() {
                return state;
            }
        };
    }

    public static ServiceInstance serviceInstanceFor(Service service) {
        ServerConfig config = new ServerConfig(Duration.ZERO, WorkerTaskRestartStrategy.AFTER_TERMINATION_GRACE_PERIOD, new ServerConfig.Liveness(Boolean.valueOf(true), Duration.ZERO, Duration.ofSeconds(10L), Duration.ZERO, Duration.ZERO));
        return new ServiceInstance(service.getId(), service.getType(), service.getState(), new ServerInstance(ServerInstance.Type.SERVER, "N/A", Network.localHostname(), Map.of(), Set.of()), Instant.now().truncatedTo(ChronoUnit.MILLIS), Instant.now().truncatedTo(ChronoUnit.MILLIS), List.of(), config, Map.of(), Set.of());
    }
}

