/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.server.Service;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ServiceTest {
    ServiceTest() {
    }

    @Test
    void shouldReturnValidTransitionForRunning() {
        List<Service.ServiceState> states = List.of(Service.ServiceState.RUNNING, Service.ServiceState.DISCONNECTED, Service.ServiceState.TERMINATING);
        states.forEach(status -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.RUNNING.isValidTransition(status)));
    }

    @Test
    void shouldReturnValidTransitionForDisconnected() {
        List<Service.ServiceState> states = List.of(Service.ServiceState.DISCONNECTED, Service.ServiceState.TERMINATING, Service.ServiceState.NOT_RUNNING);
        states.forEach(status -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.DISCONNECTED.isValidTransition(status)));
    }

    @Test
    void shouldReturnValidTransitionForPendingShutdown() {
        List<Service.ServiceState> states = List.of(Service.ServiceState.TERMINATING, Service.ServiceState.TERMINATED_FORCED, Service.ServiceState.TERMINATED_GRACEFULLY);
        states.forEach(status -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.TERMINATING.isValidTransition(status)));
    }

    @Test
    void shouldReturnValidTransitionForForcedShutdown() {
        List<Service.ServiceState> states = List.of(Service.ServiceState.TERMINATED_FORCED, Service.ServiceState.NOT_RUNNING);
        states.forEach(status -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.TERMINATED_FORCED.isValidTransition(status)));
    }

    @Test
    void shouldReturnValidTransitionForGracefulShutdown() {
        List<Service.ServiceState> states = List.of(Service.ServiceState.TERMINATED_GRACEFULLY, Service.ServiceState.NOT_RUNNING);
        states.forEach(status -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.TERMINATED_GRACEFULLY.isValidTransition(status)));
    }

    @Test
    void shouldReturnValidTransitionForNotRunning() {
        List<Service.ServiceState> states = List.of(Service.ServiceState.INACTIVE);
        states.forEach(status -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.NOT_RUNNING.isValidTransition(status)));
    }

    @Test
    void shouldReturnTrueForDisconnectedOrPendingShutDown() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.DISCONNECTED.isDisconnectedOrTerminating());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Service.ServiceState.TERMINATING.isDisconnectedOrTerminating());
    }

    @Test
    void shouldMapRenamedEmptyStateToInactive() {
        Assertions.assertThat((Comparable)Service.ServiceState.fromString((String)"EMPTY")).isEqualTo((Object)Service.ServiceState.INACTIVE);
    }
}

