/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionFlow;
import io.kestra.plugin.core.condition.ExecutionNamespace;
import io.kestra.plugin.core.trigger.Schedule;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest
class ConditionServiceTest {
    @Inject
    ConditionService conditionService;
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;

    ConditionServiceTest() {
    }

    @Test
    void valid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        RunContext runContext = this.runContextFactory.of((FlowInterface)flow, execution);
        ConditionContext conditionContext = this.conditionService.conditionContext(runContext, flow, execution);
        List<Condition> conditions = Arrays.asList(ExecutionFlow.builder().namespace(Property.ofValue((Object)flow.getNamespace())).flowId(Property.ofValue((Object)flow.getId())).build(), ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace())).build());
        boolean valid = this.conditionService.valid((FlowInterface)flow, conditions, conditionContext);
        Assertions.assertThat((boolean)valid).isTrue();
    }

    @Test
    void exception() {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Flow flow = TestsUtils.mockFlow();
        Schedule schedule = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("unit")).type(Schedule.class.getName())).cron("0 0 1 * *").build();
        RunContext runContext = this.runContextFactory.of(flow, (AbstractTrigger)schedule);
        ConditionContext conditionContext = this.conditionService.conditionContext(runContext, flow, null);
        List<ExecutionFlow> conditions = Collections.singletonList(ExecutionFlow.builder().namespace(Property.ofValue((Object)flow.getNamespace())).flowId(Property.ofValue((Object)flow.getId())).build());
        this.conditionService.valid((FlowInterface)flow, conditions, conditionContext);
        LogEntry matchingLog = TestsUtils.awaitLog(logs, logEntry -> logEntry.getNamespace().equals("io.kestra.core.services.conditionservicetest") && logEntry.getFlowId().equals("exception"));
        receive.blockLast();
        Assertions.assertThat((Object)matchingLog).isNotNull();
    }
}

