/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.validations.ValidateConstraintViolation;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.services.FlowService;
import io.kestra.plugin.core.debug.Echo;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.flow.Subflow;
import io.kestra.plugin.core.trigger.Flow;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FlowServiceTest {
    private static final String TEST_NAMESPACE = "io.kestra.unittest";
    @Inject
    private FlowService flowService;
    @Inject
    private FlowRepositoryInterface flowRepository;

    FlowServiceTest() {
    }

    private static FlowWithSource create(String flowId, String taskId, Integer revision) {
        return FlowServiceTest.create(null, TEST_NAMESPACE, flowId, taskId, revision);
    }

    private static FlowWithSource create(String tenantId, String namespace, String flowId, String taskId, Integer revision) {
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id(flowId)).namespace(namespace)).tenantId(tenantId)).revision(revision)).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(taskId)).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build()))).build();
        return flow.toBuilder().source(flow.sourceOrGenerateIfNull()).build();
    }

    @Test
    void shouldReturnTrueWhenValidatingFlowGivenDefaults() {
        String source = "id: test\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n  - id: log\n    type: io.kestra.plugin.core.log.Log\n    message: This is a message\npluginDefaults:\n  - type: io.kestra.plugin.core\n    values:\n      level: WARN\n      uri: https://kestra.io\n";
        List results = this.flowService.validate("my-tenant", source);
        Assertions.assertThat((List)results).hasSize(1);
        Assertions.assertThat((Object)((ValidateConstraintViolation)results.getFirst())).isEqualTo((Object)new ValidateConstraintViolation("test", TEST_NAMESPACE, 0, null, false, List.of(), List.of(), List.of()));
    }

    @Test
    void importFlow() throws FlowProcessingException {
        String source = "id: import\nnamespace: some.namespace\ntasks:\n- id: task\n  type: io.kestra.plugin.core.log.Log\n  message: Hello";
        FlowWithSource importFlow = this.flowService.importFlow("my-tenant", source);
        Assertions.assertThat((String)importFlow.getId()).isEqualTo("import");
        Assertions.assertThat((String)importFlow.getNamespace()).isEqualTo("some.namespace");
        Assertions.assertThat((Integer)importFlow.getRevision()).isEqualTo(1);
        Assertions.assertThat((int)importFlow.getTasks().size()).isEqualTo(1);
        Assertions.assertThat((String)((Task)importFlow.getTasks().getFirst()).getId()).isEqualTo("task");
        Optional fromDb = this.flowRepository.findByIdWithSource("my-tenant", "some.namespace", "import", Optional.empty());
        Assertions.assertThat((boolean)fromDb.isPresent()).isTrue();
        Assertions.assertThat((Integer)((FlowWithSource)fromDb.get()).getRevision()).isEqualTo(1);
        Assertions.assertThat((String)((FlowWithSource)fromDb.get()).getSource()).isEqualTo(source);
        source = source.replace("id: task", "id: replaced_task");
        importFlow = this.flowService.importFlow("my-tenant", source);
        Assertions.assertThat((Integer)importFlow.getRevision()).isEqualTo(2);
        Assertions.assertThat((int)importFlow.getTasks().size()).isEqualTo(1);
        Assertions.assertThat((String)((Task)importFlow.getTasks().getFirst()).getId()).isEqualTo("replaced_task");
        fromDb = this.flowRepository.findByIdWithSource("my-tenant", "some.namespace", "import", Optional.empty());
        Assertions.assertThat((boolean)fromDb.isPresent()).isTrue();
        Assertions.assertThat((Integer)((FlowWithSource)fromDb.get()).getRevision()).isEqualTo(2);
        Assertions.assertThat((String)((FlowWithSource)fromDb.get()).getSource()).isEqualTo(source);
    }

    @Test
    void importFlow_DryRun() throws FlowProcessingException {
        String oldSource = "id: import_dry\nnamespace: some.namespace\ntasks:\n- id: task\n  type: io.kestra.plugin.core.log.Log\n  message: Hello";
        FlowWithSource importFlow = this.flowService.importFlow("my-tenant", oldSource);
        Assertions.assertThat((String)importFlow.getId()).isEqualTo("import_dry");
        Assertions.assertThat((String)importFlow.getNamespace()).isEqualTo("some.namespace");
        Assertions.assertThat((Integer)importFlow.getRevision()).isEqualTo(1);
        Assertions.assertThat((int)importFlow.getTasks().size()).isEqualTo(1);
        Assertions.assertThat((String)((Task)importFlow.getTasks().getFirst()).getId()).isEqualTo("task");
        Optional fromDb = this.flowRepository.findByIdWithSource("my-tenant", "some.namespace", "import_dry", Optional.empty());
        Assertions.assertThat((boolean)fromDb.isPresent()).isTrue();
        Assertions.assertThat((Integer)((FlowWithSource)fromDb.get()).getRevision()).isEqualTo(1);
        Assertions.assertThat((String)((FlowWithSource)fromDb.get()).getSource()).isEqualTo(oldSource);
        String newSource = oldSource.replace("id: task", "id: replaced_task");
        importFlow = this.flowService.importFlow("my-tenant", newSource, true);
        Assertions.assertThat((Integer)importFlow.getRevision()).isEqualTo(2);
        Assertions.assertThat((int)importFlow.getTasks().size()).isEqualTo(1);
        Assertions.assertThat((String)((Task)importFlow.getTasks().getFirst()).getId()).isEqualTo("replaced_task");
        fromDb = this.flowRepository.findByIdWithSource("my-tenant", "some.namespace", "import_dry", Optional.empty());
        Assertions.assertThat((boolean)fromDb.isPresent()).isTrue();
        Assertions.assertThat((Integer)((FlowWithSource)fromDb.get()).getRevision()).isEqualTo(1);
        Assertions.assertThat((String)((FlowWithSource)fromDb.get()).getSource()).isEqualTo(oldSource);
    }

    @Test
    void sameRevisionWithDeletedOrdered() {
        Stream<FlowInterface> stream = Stream.of(FlowServiceTest.create("test", "test", 1), FlowServiceTest.create("test", "test2", 2), FlowServiceTest.create("test", "test2", 2).toDeleted(), FlowServiceTest.create("test", "test2", 4));
        List collect = this.flowService.keepLastVersion(stream).toList();
        Assertions.assertThat((int)collect.size()).isEqualTo(1);
        Assertions.assertThat((boolean)((FlowInterface)collect.getFirst()).isDeleted()).isFalse();
        Assertions.assertThat((Integer)((FlowInterface)collect.getFirst()).getRevision()).isEqualTo(4);
    }

    @Test
    void sameRevisionWithDeletedSameRevision() {
        Stream<FlowInterface> stream = Stream.of(FlowServiceTest.create("test2", "test2", 1), FlowServiceTest.create("test", "test", 1), FlowServiceTest.create("test", "test2", 2), FlowServiceTest.create("test", "test3", 3), FlowServiceTest.create("test", "test2", 2).toDeleted());
        List collect = this.flowService.keepLastVersion(stream).toList();
        Assertions.assertThat((int)collect.size()).isEqualTo(1);
        Assertions.assertThat((boolean)((FlowInterface)collect.getFirst()).isDeleted()).isFalse();
        Assertions.assertThat((String)((FlowInterface)collect.getFirst()).getId()).isEqualTo("test2");
    }

    @Test
    void sameRevisionWithDeletedUnordered() {
        Stream<FlowInterface> stream = Stream.of(FlowServiceTest.create("test", "test", 1), FlowServiceTest.create("test", "test2", 2), FlowServiceTest.create("test", "test2", 4), FlowServiceTest.create("test", "test2", 2).toDeleted());
        List collect = this.flowService.keepLastVersion(stream).toList();
        Assertions.assertThat((int)collect.size()).isEqualTo(1);
        Assertions.assertThat((boolean)((FlowInterface)collect.getFirst()).isDeleted()).isFalse();
        Assertions.assertThat((Integer)((FlowInterface)collect.getFirst()).getRevision()).isEqualTo(4);
    }

    @Test
    void multipleFlow() {
        Stream<FlowInterface> stream = Stream.of(FlowServiceTest.create("test", "test", 2), FlowServiceTest.create("test", "test2", 1), FlowServiceTest.create("test2", "test2", 1), FlowServiceTest.create("test2", "test3", 3), FlowServiceTest.create("test3", "test1", 2), FlowServiceTest.create("test3", "test2", 3));
        List collect = this.flowService.keepLastVersion(stream).toList();
        Assertions.assertThat((int)collect.size()).isEqualTo(3);
        Assertions.assertThat((Integer)collect.stream().filter(flow -> flow.getId().equals("test")).findFirst().orElseThrow().getRevision()).isEqualTo(2);
        Assertions.assertThat((Integer)collect.stream().filter(flow -> flow.getId().equals("test2")).findFirst().orElseThrow().getRevision()).isEqualTo(3);
        Assertions.assertThat((Integer)collect.stream().filter(flow -> flow.getId().equals("test3")).findFirst().orElseThrow().getRevision()).isEqualTo(3);
    }

    @Test
    void warnings() {
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowServiceTest.create("test", "test", 1).toBuilder().namespace("system")).triggers(List.of(((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.plugin.core.trigger.Flow.builder().id("flow-trigger")).type(io.kestra.plugin.core.trigger.Flow.class.getName())).build()))).build();
        List warnings = this.flowService.warnings((Flow)flow, null);
        Assertions.assertThat((int)warnings.size()).isEqualTo(1);
        Assertions.assertThat((List)warnings).containsExactlyInAnyOrder((Object[])new String[]{"This flow will be triggered for EVERY execution of EVERY flow on your instance. We recommend adding the preconditions property to the Flow trigger 'flow-trigger'."});
    }

    @Test
    void aliases() {
        List warnings = this.flowService.relocations("id: hello-alias\nnamespace: myteam\n\ntasks:\n  - id: log-alias\n    type: io.kestra.core.runners.test.task.Alias\n    message: Hello, Alias\n  - id: log-task\n    type: io.kestra.core.runners.test.TaskWithAlias\n    message: Hello, Task\n  - id: each\n    type: io.kestra.plugin.core.flow.ForEach\n    values: \n      - 1\n      - 2\n      - 3\n    tasks:\n      - id: log-alias-each\n        type: io.kestra.core.runners.test.task.Alias\n        message: Hello, {{taskrun.value}}");
        Assertions.assertThat((int)warnings.size()).isEqualTo(2);
        Assertions.assertThat((String)((FlowService.Relocation)warnings.getFirst()).from()).isEqualTo("io.kestra.core.runners.test.task.Alias");
        Assertions.assertThat((String)((FlowService.Relocation)warnings.getFirst()).to()).isEqualTo("io.kestra.core.runners.test.TaskWithAlias");
    }

    @Test
    void propertyRenamingDeprecation() {
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id("flowId")).namespace(TEST_NAMESPACE)).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("inputWithId")).type(Type.STRING)).build(), ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().name("inputWithName")).type(Type.STRING)).build()))).tasks(Collections.singletonList(((Echo.EchoBuilder)((Echo.EchoBuilder)Echo.builder().id("taskId")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build()))).build();
        Assertions.assertThat((List)this.flowService.deprecationPaths((Flow)flow)).containsExactlyInAnyOrder((Object[])new String[]{"inputs[1].name", "tasks[0]"});
    }

    @Test
    void isAllowedNamespace() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.flowService.isAllowedNamespace("tenant", "namespace", "fromTenant", "fromNamespace"));
    }

    @Test
    void checkAllowedNamespace() {
        this.flowService.checkAllowedNamespace("tenant", "namespace", "fromTenant", "fromNamespace");
    }

    @Test
    void areAllowedAllNamespaces() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.flowService.areAllowedAllNamespaces("tenant", "fromTenant", "fromNamespace"));
    }

    @Test
    void checkAllowedAllNamespaces() {
        this.flowService.checkAllowedAllNamespaces("tenant", "fromTenant", "fromNamespace");
    }

    @Test
    void delete() {
        FlowWithSource flow = FlowServiceTest.create("deleteTest", "test", 1);
        FlowWithSource saved = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        Assertions.assertThat((boolean)this.flowRepository.findById(flow.getTenantId(), flow.getNamespace(), flow.getId()).isPresent()).isTrue();
        this.flowService.delete(saved);
        Assertions.assertThat((boolean)this.flowRepository.findById(flow.getTenantId(), flow.getNamespace(), flow.getId()).isPresent()).isFalse();
    }

    @Test
    void findByNamespacePrefix() {
        FlowWithSource flow = FlowServiceTest.create(null, "some.namespace", "findByTest", "test", 1);
        this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        Assertions.assertThat((int)this.flowService.findByNamespacePrefix(null, "some.namespace").size()).isEqualTo(1);
    }

    @Test
    void findById() {
        FlowWithSource flow = FlowServiceTest.create("findByIdTest", "test", 1);
        FlowWithSource saved = this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        Assertions.assertThat((boolean)this.flowService.findById(null, saved.getNamespace(), saved.getId()).isPresent()).isTrue();
    }

    @Test
    void checkSubflowNotFound() {
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)FlowServiceTest.create("mainFlow", "task", 1).toBuilder().tasks(List.of(((Subflow.SubflowBuilder)((Subflow.SubflowBuilder)Subflow.builder().id("subflowTask")).type(Subflow.class.getName())).namespace(TEST_NAMESPACE).flowId("nonExistentSubflow").build()))).build();
        List exceptions = this.flowService.checkValidSubflows((Flow)flow, null);
        Assertions.assertThat((int)exceptions.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)exceptions.iterator().next())).isEqualTo("The subflow 'nonExistentSubflow' not found in namespace 'io.kestra.unittest'.");
    }

    @Test
    void checkValidSubflow() {
        FlowWithSource subflow = FlowServiceTest.create("existingSubflow", "task", 1);
        this.flowRepository.create(GenericFlow.of((FlowInterface)subflow));
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)FlowServiceTest.create("mainFlow", "task", 1).toBuilder().tasks(List.of(((Subflow.SubflowBuilder)((Subflow.SubflowBuilder)Subflow.builder().id("subflowTask")).type(Subflow.class.getName())).namespace(TEST_NAMESPACE).flowId("existingSubflow").build()))).build();
        List exceptions = this.flowService.checkValidSubflows((Flow)flow, null);
        Assertions.assertThat((int)exceptions.size()).isZero();
    }

    @Test
    void shouldReturnValidationForRunnablePropsOnFlowable() {
        String source = "id: dolphin_164914\nnamespace: company.team\n\ntasks:\n  - id: for\n    type: io.kestra.plugin.core.flow.ForEach\n    values: [1, 2, 3]\n    workerGroup:\n      key: toto\n    timeout: PT10S\n    taskCache:\n      enabled: true\n    tasks:\n    - id: hello\n      type: io.kestra.plugin.core.log.Log\n      message: Hello World! \ud83d\ude80\n      workerGroup:\n        key: toto\n      timeout: PT10S\n      taskCache:\n        enabled: true\n";
        List results = this.flowService.validate("my-tenant", source);
        Assertions.assertThat((List)results).hasSize(1);
        Assertions.assertThat((List)((ValidateConstraintViolation)results.getFirst()).getWarnings()).hasSize(3);
        Assertions.assertThat((List)((ValidateConstraintViolation)results.getFirst()).getWarnings()).containsExactlyInAnyOrder((Object[])new String[]{"The task 'for' cannot use the 'timeout' property as it's only relevant for runnable tasks.", "The task 'for' cannot use the 'taskCache' property as it's only relevant for runnable tasks.", "The task 'for' cannot use the 'workerGroup' property as it's only relevant for runnable tasks."});
    }

    @Test
    void shouldReturnValidationErrorForReservedFlowId() {
        String source = "id: pause\nnamespace: io.kestra.unittest\ntasks:\n  - id: task\n    type: io.kestra.plugin.core.log.Log\n    message: Reserved id test\n";
        List results = this.flowService.validate("my-tenant", source);
        Assertions.assertThat((List)results).hasSize(1);
        Assertions.assertThat((String)((ValidateConstraintViolation)results.getFirst()).getConstraints()).contains(new CharSequence[]{"Flow id is a reserved keyword: pause"});
    }
}

