/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.repositories.KvMetadataRepositoryInterface;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.services.NamespaceService;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.kv.InternalKVStore;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVStoreException;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.micronaut.test.annotation.MockBean;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class KVStoreServiceTest {
    private static final String TEST_EXISTING_NAMESPACE = "io.kestra.unittest";
    @Inject
    KvMetadataRepositoryInterface kvMetadataRepository;
    @Inject
    KVStoreService storeService;
    @Inject
    StorageInterface storageInterface;

    KVStoreServiceTest() {
    }

    @Test
    void shouldGetKVStoreForExistingNamespaceGivenFromNull() {
        Assertions.assertNotNull((Object)this.storeService.get("main", TEST_EXISTING_NAMESPACE, null));
    }

    @Test
    void shouldThrowExceptionWhenAccessingKVStoreForNonExistingNamespace() {
        KVStoreException exception = (KVStoreException)Assertions.assertThrows(KVStoreException.class, () -> this.storeService.get("main", "io.kestra.unittest.unknown", null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("namespace 'io.kestra.unittest.unknown' does not exist"));
    }

    @Test
    void shouldGetKVStoreForAnyNamespaceWhenAccessingFromChildNamespace() {
        Assertions.assertNotNull((Object)this.storeService.get("main", "io.kestra", TEST_EXISTING_NAMESPACE));
    }

    @Test
    void shouldGetKVStoreFromNonExistingNamespaceWithAKV() throws IOException {
        InternalKVStore kvStore = new InternalKVStore("main", "system", this.storageInterface, this.kvMetadataRepository);
        kvStore.put("key", new KVValueAndMetadata(new KVMetadata("myDescription", Duration.ofHours(1L)), (Object)"value"));
        Assertions.assertNotNull((Object)this.storeService.get("main", "system", null));
    }

    @MockBean(value=NamespaceService.class)
    public static class MockNamespaceService
    extends NamespaceService {
        public MockNamespaceService() {
            super(Optional.empty());
        }

        public boolean isNamespaceExists(String tenant, String namespace) {
            return namespace.equals(KVStoreServiceTest.TEST_EXISTING_NAMESPACE);
        }
    }
}

