/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.LabelService;
import io.kestra.plugin.core.execution.Labels;
import io.kestra.plugin.core.trigger.Schedule;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class LabelServiceTest {
    @Inject
    private TestRunContextFactory runContextFactory;

    LabelServiceTest() {
    }

    @Test
    void shouldFilterSystemLabels() {
        Flow flow = ((Flow.FlowBuilder)Flow.builder().labels(List.of(new Label("key", "value"), new Label("system.label", "systemValue")))).build();
        List labels = LabelService.labelsExcludingSystem((FlowInterface)flow);
        Assertions.assertThat((List)labels).hasSize(1);
        Assertions.assertThat((Object)((Label)labels.getFirst())).isEqualTo((Object)new Label("key", "value"));
    }

    @Test
    void shouldReturnLabelsFromFlowAndTrigger() {
        RunContext runContext = this.runContextFactory.of(Map.of("variable", "variableValue"));
        Flow flow = ((Flow.FlowBuilder)Flow.builder().labels(List.of(new Label("key", "value"), new Label("system.label", "systemValue")))).build();
        Schedule trigger = ((Schedule.ScheduleBuilder)Schedule.builder().labels(List.of(new Label("scheduleLabel", "scheduleValue"), new Label("variable", "{{variable}}")))).build();
        List labels = LabelService.fromTrigger((RunContext)runContext, (FlowInterface)flow, (AbstractTrigger)trigger);
        Assertions.assertThat((List)labels).hasSize(3);
        Assertions.assertThat((List)labels).contains((Object[])new Label[]{new Label("key", "value"), new Label("scheduleLabel", "scheduleValue"), new Label("variable", "variableValue")});
    }

    @Test
    void shouldFilterNonRenderableLabels() {
        RunContext runContext = this.runContextFactory.of();
        Flow flow = ((Flow.FlowBuilder)Flow.builder().labels(List.of(new Label("key", "value"), new Label("system.label", "systemValue")))).build();
        Schedule trigger = ((Schedule.ScheduleBuilder)Schedule.builder().labels(List.of(new Label("scheduleLabel", "scheduleValue"), new Label("variable", "{{variable}}")))).build();
        List labels = LabelService.fromTrigger((RunContext)runContext, (FlowInterface)flow, (AbstractTrigger)trigger);
        Assertions.assertThat((List)labels).hasSize(2);
        Assertions.assertThat((List)labels).contains((Object[])new Label[]{new Label("key", "value"), new Label("scheduleLabel", "scheduleValue")});
    }

    @Test
    void containsAll() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)LabelService.containsAll(null, List.of(new Label("key", "value"))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)LabelService.containsAll(Collections.emptyList(), List.of(new Label("key", "value"))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)LabelService.containsAll(List.of(new Label("key1", "value1")), List.of(new Label("key2", "value2"))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)LabelService.containsAll(List.of(new Label("key", "value")), null));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)LabelService.containsAll(List.of(new Label("key", "value")), Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)LabelService.containsAll(List.of(new Label("key1", "value1")), List.of(new Label("key1", "value1"))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)LabelService.containsAll(List.of(new Label("key1", "value1"), new Label("key2", "value2")), List.of(new Label("key1", "value1"))));
    }

    @Test
    void shouldThrowExceptionOnEmptyLabelValueInLabelsTask() throws Exception {
        Labels task = ((Labels.LabelsBuilder)((Labels.LabelsBuilder)Labels.builder().id("test")).type(Labels.class.getName())).labels(Map.of("invalidLabel", "")).build();
        RunContext runContext = this.runContextFactory.of();
        Execution execution = Execution.builder().id("execId").namespace("test.ns").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> task.update(execution, runContext)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Label values cannot be empty");
    }
}

